package com.xforceplus.ultraman.app.financialsettlement.metadata.validator;

import com.xforceplus.ultraman.app.financialsettlement.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.financialsettlement.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(Module.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Module.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Module.class.getSimpleName());
            }
        }
        if(clazz.equals(Function.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Function.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Function.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeDimension.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeDimension.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeDimension.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeType.class.getSimpleName());
            }
        }
        if(clazz.equals(Cycle.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Cycle.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Cycle.class.getSimpleName());
            }
        }
        if(clazz.equals(Region.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Region.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Region.class.getSimpleName());
            }
        }
        if(clazz.equals(CostType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CostType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CostType.class.getSimpleName());
            }
        }
        if(clazz.equals(Type.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Type.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Type.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeRuleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeRuleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeRuleType.class.getSimpleName());
            }
        }
        if(clazz.equals(WhetherCalculate.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WhetherCalculate.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WhetherCalculate.class.getSimpleName());
            }
        }
        if(clazz.equals(InputWay.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InputWay.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InputWay.class.getSimpleName());
            }
        }
        if(clazz.equals(Profession.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Profession.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Profession.class.getSimpleName());
            }
        }
        if(clazz.equals(Phase.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Phase.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Phase.class.getSimpleName());
            }
        }
        if(clazz.equals(ActivityType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ActivityType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ActivityType.class.getSimpleName());
            }
        }
        if(clazz.equals(SolutionType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SolutionType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SolutionType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(SubStat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SubStat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SubStat.class.getSimpleName());
            }
        }
        if(clazz.equals(AllocationStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AllocationStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AllocationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductPhase.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProductPhase.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProductPhase.class.getSimpleName());
            }
        }
        if(clazz.equals(CostBelong.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CostBelong.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CostBelong.class.getSimpleName());
            }
        }
        if(clazz.equals(Property.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Property.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Property.class.getSimpleName());
            }
        }
        if(clazz.equals(ContractAppoint.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ContractAppoint.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ContractAppoint.class.getSimpleName());
            }
        }
        if(clazz.equals(TravelExpensePayer.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TravelExpensePayer.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TravelExpensePayer.class.getSimpleName());
            }
        }
        if(clazz.equals(SignInvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SignInvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SignInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentNature.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentNature.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentNature.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProductType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProductType.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementCondition.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SettlementCondition.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SettlementCondition.class.getSimpleName());
            }
        }
        if(clazz.equals(StartChargeCondition.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StartChargeCondition.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StartChargeCondition.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductFuctionType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProductFuctionType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProductFuctionType.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductFuctionDesc.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProductFuctionDesc.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProductFuctionDesc.class.getSimpleName());
            }
        }
        if(clazz.equals(UseInvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UseInvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UseInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IncomeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IncomeType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeType.class.getSimpleName());
            }
        }
        if(clazz.equals(WarrantyType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WarrantyType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WarrantyType.class.getSimpleName());
            }
        }
        if(clazz.equals(JobType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JobType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JobType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeVaildLogo.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeVaildLogo.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeVaildLogo.class.getSimpleName());
            }
        }
        if(clazz.equals(ReconcilationStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReconcilationStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReconcilationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReturnMoneyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReturnMoneyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReturnMoneyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Dimension.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Dimension.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Dimension.class.getSimpleName());
            }
        }
        if(clazz.equals(WhtherOrNot.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WhtherOrNot.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WhtherOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CurrentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CurrentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CurrentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SynchronizeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SynchronizeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SynchronizeType.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentRequirement.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentRequirement.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentRequirement.class.getSimpleName());
            }
        }
        if(clazz.equals(OLDNEWENUM.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OLDNEWENUM.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OLDNEWENUM.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeCodeTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeCodeTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeCodeStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeCodeStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(MemberStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MemberStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MemberStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(TakenStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TakenStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TakenStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ValidEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ValidEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ValidEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ActiveEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ActiveEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ActiveEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxNoStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxNoStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxNoStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IncomeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IncomeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RecordType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecordType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecordType.class.getSimpleName());
            }
        }
        if(clazz.equals(PmsMateDataEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PmsMateDataEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PmsMateDataEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ContractStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ContractStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ContractStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FinancifalBudgetType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FinancifalBudgetType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FinancifalBudgetType.class.getSimpleName());
            }
        }
        if(clazz.equals(PropertyEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PropertyEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PropertyEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ReconciliationStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReconciliationStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReconciliationStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentMethodEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentMethodEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentMethodEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeBizDimensionEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeBizDimensionEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeBizDimensionEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderInvoiceStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderInvoiceStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderInvoiceStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(CompensateEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CompensateEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CompensateEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(MultiRelationDetailEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MultiRelationDetailEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MultiRelationDetailEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(SupplementaryAgreementTypesEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SupplementaryAgreementTypesEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SupplementaryAgreementTypesEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PayType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PayType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PayType.class.getSimpleName());
            }
        }
        if(clazz.equals(ServiceOpenFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ServiceOpenFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ServiceOpenFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillingType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillingType.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductIncomeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProductIncomeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProductIncomeType.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeConfirm.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IncomeConfirm.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IncomeConfirm.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceRedFlagEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceRedFlagEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceRedFlagEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColorEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceColorEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceColorEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PayStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PayStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(SearchType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SearchType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SearchType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeCodeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeCodeType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeCodeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeCodeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeArea.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeCodeArea.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeCodeArea.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeOrganization.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeCodeOrganization.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeCodeOrganization.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeRules.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeRules.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeRules.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProductStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProductStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DeviceTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DeviceTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DeviceTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCycleEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeCycleEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeCycleEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingRuleEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillingRuleEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillingRuleEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BindTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BindTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BindTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(StandingBookStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StandingBookStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StandingBookStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(CostItem.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CostItem.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CostItem.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeBudgetType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeCodeBudgetType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeCodeBudgetType.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceptionStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceptionStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceptionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProjectStageStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProjectStageStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProjectStageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProcessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProcessType.class.getSimpleName());
            }
        }
        if(clazz.equals(ModuleEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ModuleEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ModuleEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(DimensionEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DimensionEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DimensionEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BillTemplate.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillTemplate.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillTemplate.class.getSimpleName());
            }
        }
        if(clazz.equals(BillTemplateDetail.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillTemplateDetail.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillTemplateDetail.class.getSimpleName());
            }
        }
        if(clazz.equals(ProjectItemStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProjectItemStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProjectItemStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ProjectStageEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProjectStageEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProjectStageEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(CapitalVerifyRuleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CapitalVerifyRuleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CapitalVerifyRuleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ContractTypes.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ContractTypes.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ContractTypes.class.getSimpleName());
            }
        }
        if(clazz.equals(TravelExpensesBearer.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TravelExpensesBearer.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TravelExpensesBearer.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SmallOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SmallOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallOrderWay.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SmallOrderWay.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SmallOrderWay.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallOrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SmallOrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SmallOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallContractStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SmallContractStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SmallContractStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallPaymentType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SmallPaymentType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SmallPaymentType.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallActivateStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SmallActivateStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SmallActivateStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallContractStatusMapping.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SmallContractStatusMapping.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SmallContractStatusMapping.class.getSimpleName());
            }
        }
        if(clazz.equals(SourceMateDataEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SourceMateDataEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SourceMateDataEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(LegalEntityBudgetCenterType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LegalEntityBudgetCenterType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LegalEntityBudgetCenterType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeInvalidPushEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeCodeInvalidPushEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeCodeInvalidPushEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(CdSignEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CdSignEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CdSignEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ForIndividEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ForIndividEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ForIndividEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(AdjustStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AdjustStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AdjustStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(FkjBillTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FkjBillTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FkjBillTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(FkjPayWayEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FkjPayWayEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FkjPayWayEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(FjkApproveStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FjkApproveStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FjkApproveStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(FkjExpensesTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FkjExpensesTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FkjExpensesTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(NotTakenChannelEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NotTakenChannelEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NotTakenChannelEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BillTypeSecondEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillTypeSecondEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillTypeSecondEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(TenantTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TenantTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TenantTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BsEmployTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BsEmployTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BsEmployTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeRelationEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeCodeRelationEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeCodeRelationEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallOrderserviceCloseType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SmallOrderserviceCloseType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SmallOrderserviceCloseType.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessDimension.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessDimension.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessDimension.class.getSimpleName());
            }
        }
        if(clazz.equals(YesNoEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YesNoEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YesNoEnum.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
