package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 功能模块
 * </p>
 *
 * @author ultraman
 * @since 2022-06-30
 */
public enum ModuleEnum {

    _10("10", "回款核销"),
    _15("15", "结算统计"),
    _20("20", "收入"),
    _25("25", "数据对接");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ModuleEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ModuleEnum fromCode(String code){
        switch(code) {
            case "10":
                return _10;
            case "15":
                return _15;
            case "20":
                return _20;
            case "25":
                return _25;
            default:
                return null;
        }
    }
}
