package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否
 * </p>
 *
 * @author ultraman
 * @since 2022-06-30
 */
public enum WhtherOrNot {

    FALSE("false", "否"),
    TRUE("true", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WhtherOrNot(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WhtherOrNot fromCode(String code){
        switch(code) {
            case "false":
                return FALSE;
            case "true":
                return TRUE;
            default:
                return null;
        }
    }
}
