package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 查询方式
 * </p>
 *
 * @author ultraman
 * @since 2022-07-07
 */
public enum SearchType {

    ORDER("order", "订单"),
    INVOICE("invoice", "发票"),
    TAX("tax", "税号");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SearchType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SearchType fromCode(String code){
        switch(code) {
            case "order":
                return ORDER;
            case "invoice":
                return INVOICE;
            case "tax":
                return TAX;
            default:
                return null;
        }
    }
}
