package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * project_info_under_contract
 * </p>
 *
 * @author ultraman
 * @since 2022-07-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ProjectInfoUnderContract implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 产品编号
   */
  private String productCode;
  /**
   * 项目分期阶段
   */
  private String projectStage;
  /**
   * 项目阶段状态
   */
  private String projectStageStatus;
  /**
   * 项目经理
   */
  private String projectManager;
  /**
   * 项目阶段完成时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime projectStageFinishTime;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 项目编号
   */
  private String projectNo;
  /**
   * 项目分期名称
   */
  private String projectItemName;
  /**
   * 项目chargeCode
   */
  private String projectItemNo;
  /**
   * 验收状态
   */
  private String receptionItemStatus;
  /**
   *  验收交付物
   */
  private String receptionItemDeliverables;
  /**
   * 项目分期创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime projectItemCreateTime;
  /**
   * 项目分期状态
   */
  private String projectItemStatus;

  /**
   * 对一关联关系 关联对象 contract
   */
  private Long conrtactProjectConnectionId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("productName", productName);
      map.put("productCode", productCode);
      map.put("projectStage", projectStage);
      map.put("projectStageStatus", projectStageStatus);
      map.put("projectManager", projectManager);
      map.put("projectStageFinishTime", BocpGenUtils.toTimestamp(projectStageFinishTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("projectNo", projectNo);
      map.put("projectItemName", projectItemName);
      map.put("projectItemNo", projectItemNo);
      map.put("receptionItemStatus", receptionItemStatus);
      map.put("receptionItemDeliverables", receptionItemDeliverables);
      map.put("projectItemCreateTime", BocpGenUtils.toTimestamp(projectItemCreateTime));
      map.put("projectItemStatus", projectItemStatus);

      map.put("conrtactProjectConnection.id", conrtactProjectConnectionId);
      return map;
  }

  public static ProjectInfoUnderContract fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ProjectInfoUnderContract entity = new ProjectInfoUnderContract();

    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectStage")) {
      Object obj = map.get("projectStage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectStage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectStageStatus")) {
      Object obj = map.get("projectStageStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectStageStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectManager")) {
      Object obj = map.get("projectManager");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectManager((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectStageFinishTime")) {
      Object obj = map.get("projectStageFinishTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProjectStageFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setProjectStageFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProjectStageFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setProjectStageFinishTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemNo")) {
      Object obj = map.get("projectItemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receptionItemStatus")) {
      Object obj = map.get("receptionItemStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceptionItemStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receptionItemDeliverables")) {
      Object obj = map.get("receptionItemDeliverables");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceptionItemDeliverables((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemCreateTime")) {
      Object obj = map.get("projectItemCreateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProjectItemCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setProjectItemCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProjectItemCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setProjectItemCreateTime(null);
      }
    }
    if(map.containsKey("projectItemStatus")) {
      Object obj = map.get("projectItemStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectItemStatus((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("conrtactProjectConnection.id")) {
       Object obj = map.get("conrtactProjectConnection.id");
       if(obj instanceof Long) {
         entity.setConrtactProjectConnectionId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setConrtactProjectConnectionId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectStage")) {
      Object obj = map.get("projectStage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectStage((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectStageStatus")) {
      Object obj = map.get("projectStageStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectStageStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectManager")) {
      Object obj = map.get("projectManager");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectManager((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectStageFinishTime")) {
      Object obj = map.get("projectStageFinishTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setProjectStageFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setProjectStageFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProjectStageFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setProjectStageFinishTime(null);
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectItemName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectItemNo")) {
      Object obj = map.get("projectItemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectItemNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receptionItemStatus")) {
      Object obj = map.get("receptionItemStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceptionItemStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receptionItemDeliverables")) {
      Object obj = map.get("receptionItemDeliverables");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceptionItemDeliverables((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectItemCreateTime")) {
      Object obj = map.get("projectItemCreateTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setProjectItemCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setProjectItemCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProjectItemCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setProjectItemCreateTime(null);
      }
   }
    if(map.containsKey("projectItemStatus")) {
      Object obj = map.get("projectItemStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectItemStatus((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("conrtactProjectConnection.id")) {
    Object obj = map.get("conrtactProjectConnection.id");
    if(obj instanceof Long) {
        this.setConrtactProjectConnectionId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setConrtactProjectConnectionId(Long.parseLong((String)obj));
    }
  }
  }

}
