package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 财务预算科目明细类型
 * </p>
 *
 * @author ultraman
 * @since 2022-07-11
 */
public enum FinancifalBudgetType {

    _1("1", "交付人工成本预算"),
    _2("2", "交付差旅预算费用"),
    _3("3", "交付客情预算费用"),
    _4("4", "产研人工成本预算"),
    _5("5", "产研差旅预算费用"),
    _6("6", "运维预算"),
    _7("7", "超级/高级支持服务预算");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FinancifalBudgetType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FinancifalBudgetType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
