package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 产品功能分类
 * </p>
 *
 * @author ultraman
 * @since 2022-07-11
 */
public enum ProductFuctionType {

    _0("0", "无"),
    _1("1", "销项"),
    _2("2", "进项"),
    _3("3", "销项+进项"),
    _4("4", "软件"),
    _5("5", "实施"),
    _6("6", "发票机器人"),
    _7("7", "集成"),
    _8("8", "扫描仪"),
    _9("9", "税控设备");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProductFuctionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductFuctionType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
