package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ProjectBasicInfo;
import com.xforceplus.ultraman.app.financialsettlement.service.IProjectBasicInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-10-09
 */
@RestController
public class ProjectBasicInfoController {

  @Autowired
  private IProjectBasicInfoService projectBasicInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param projectBasicInfo ${table.comment}
   * @return
   */
  @GetMapping("/projectbasicinfos" )
  public XfR getProjectBasicInfos(XfPage page, ProjectBasicInfo projectBasicInfo) {
    return XfR.ok(projectBasicInfoServiceImpl.page(page, Wrappers.query(projectBasicInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/projectbasicinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(projectBasicInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param projectBasicInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/projectbasicinfos")
  public XfR save(@RequestBody ProjectBasicInfo projectBasicInfo) {
     return XfR.ok(projectBasicInfoServiceImpl.save(projectBasicInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param projectBasicInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/projectbasicinfos/{id}")
  public XfR putUpdate(@RequestBody ProjectBasicInfo projectBasicInfo,@PathVariable Long id) {
      projectBasicInfo.setId(id);
      return XfR.ok(projectBasicInfoServiceImpl.updateById(projectBasicInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param projectBasicInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/projectbasicinfos/{id}")
  public XfR patchUpdate(@RequestBody ProjectBasicInfo projectBasicInfo,@PathVariable Long id) {
      ProjectBasicInfo upprojectBasicInfo = projectBasicInfoServiceImpl.getById(id);
      if(upprojectBasicInfo != null){
        upprojectBasicInfo = ObjectCopyUtils.copyProperties(projectBasicInfo,upprojectBasicInfo,true);
      }
      return XfR.ok(projectBasicInfoServiceImpl.updateById(upprojectBasicInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/projectbasicinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(projectBasicInfoServiceImpl.removeById(id));
  }

  @PostMapping("/projectbasicinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "project_basic_info");
     params.put("request", condition);

     return XfR.ok(projectBasicInfoServiceImpl.querys(params));
  }

}
