package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.Contract;
import com.xforceplus.ultraman.app.financialsettlement.service.IContractService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 合同主信息前端控制器
 *
 * @author ultraman
 * @date 2021-11-02
 */
@RestController
public class ContractController {

  @Autowired
  private IContractService contractServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param contract 合同主信息
   * @return
   */
  @GetMapping("/contracts" )
  public XfR getContracts(XfPage page, Contract contract) {
    return XfR.ok(contractServiceImpl.page(page, Wrappers.query(contract)));
  }

  /**
   * 通过id查询合同主信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/contracts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(contractServiceImpl.getById(id));
  }

  /**
   * 新增合同主信息
   * @param contract 合同主信息
   * @return XfR
   */
  @PostMapping("/contracts")
  public XfR save(@RequestBody Contract contract) {
     return XfR.ok(contractServiceImpl.save(contract));
  }

  /**
   * 修改-传入修改后的全部数据合同主信息
   * @param contract 合同主信息
   * @return XfR
   */
  @PutMapping("/contracts/{id}")
  public XfR putUpdate(@RequestBody Contract contract,@PathVariable Long id) {
      contract.setId(id);
      return XfR.ok(contractServiceImpl.updateById(contract));
  }

  /**
   * 修改-传入修改的数据合同主信息
   * @param contract 合同主信息
   * @return XfR
   */
  @PatchMapping("/contracts/{id}")
  public XfR patchUpdate(@RequestBody Contract contract,@PathVariable Long id) {
      Contract upcontract = contractServiceImpl.getById(id);
      if(upcontract != null){
        upcontract = ObjectCopyUtils.copyProperties(contract,upcontract,true);
      }
      return XfR.ok(contractServiceImpl.updateById(upcontract));
  }

  /**
   * 通过id删除合同主信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/contracts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(contractServiceImpl.removeById(id));
  }

  @PostMapping("/contracts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "contract");
     params.put("request", condition);

     return XfR.ok(contractServiceImpl.querys(params));
  }

}
