package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.SettlementData;
import com.xforceplus.ultraman.app.financialsettlement.service.ISettlementDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 结算统计明细表前端控制器
 *
 * @author ultraman
 * @date 2021-12-30
 */
@RestController
public class SettlementDataController {

  @Autowired
  private ISettlementDataService settlementDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementData 结算统计明细表
   * @return
   */
  @GetMapping("/settlementdatas" )
  public XfR getSettlementDatas(XfPage page, SettlementData settlementData) {
    return XfR.ok(settlementDataServiceImpl.page(page, Wrappers.query(settlementData)));
  }

  /**
   * 通过id查询结算统计明细表
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementDataServiceImpl.getById(id));
  }

  /**
   * 新增结算统计明细表
   * @param settlementData 结算统计明细表
   * @return XfR
   */
  @PostMapping("/settlementdatas")
  public XfR save(@RequestBody SettlementData settlementData) {
     return XfR.ok(settlementDataServiceImpl.save(settlementData));
  }

  /**
   * 修改-传入修改后的全部数据结算统计明细表
   * @param settlementData 结算统计明细表
   * @return XfR
   */
  @PutMapping("/settlementdatas/{id}")
  public XfR putUpdate(@RequestBody SettlementData settlementData,@PathVariable Long id) {
      settlementData.setId(id);
      return XfR.ok(settlementDataServiceImpl.updateById(settlementData));
  }

  /**
   * 修改-传入修改的数据结算统计明细表
   * @param settlementData 结算统计明细表
   * @return XfR
   */
  @PatchMapping("/settlementdatas/{id}")
  public XfR patchUpdate(@RequestBody SettlementData settlementData,@PathVariable Long id) {
      SettlementData upsettlementData = settlementDataServiceImpl.getById(id);
      if(upsettlementData != null){
        upsettlementData = ObjectCopyUtils.copyProperties(settlementData,upsettlementData,true);
      }
      return XfR.ok(settlementDataServiceImpl.updateById(upsettlementData));
  }

  /**
   * 通过id删除结算统计明细表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementDataServiceImpl.removeById(id));
  }

  @PostMapping("/settlementdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_data");
     params.put("request", condition);

     return XfR.ok(settlementDataServiceImpl.querys(params));
  }

}
