package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeCodePrimeCost;
import com.xforceplus.ultraman.app.financialsettlement.service.IChargeCodePrimeCostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-10
 */
@RestController
public class ChargeCodePrimeCostController {

  @Autowired
  private IChargeCodePrimeCostService chargeCodePrimeCostServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodePrimeCost ${table.comment}
   * @return
   */
  @GetMapping("/chargecodeprimecosts" )
  public XfR getChargeCodePrimeCosts(XfPage page, ChargeCodePrimeCost chargeCodePrimeCost) {
    return XfR.ok(chargeCodePrimeCostServiceImpl.page(page, Wrappers.query(chargeCodePrimeCost)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodeprimecosts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodePrimeCostServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCodePrimeCost ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodeprimecosts")
  public XfR save(@RequestBody ChargeCodePrimeCost chargeCodePrimeCost) {
     return XfR.ok(chargeCodePrimeCostServiceImpl.save(chargeCodePrimeCost));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCodePrimeCost ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodeprimecosts/{id}")
  public XfR putUpdate(@RequestBody ChargeCodePrimeCost chargeCodePrimeCost,@PathVariable Long id) {
      chargeCodePrimeCost.setId(id);
      return XfR.ok(chargeCodePrimeCostServiceImpl.updateById(chargeCodePrimeCost));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCodePrimeCost ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodeprimecosts/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodePrimeCost chargeCodePrimeCost,@PathVariable Long id) {
      ChargeCodePrimeCost upchargeCodePrimeCost = chargeCodePrimeCostServiceImpl.getById(id);
      if(upchargeCodePrimeCost != null){
        upchargeCodePrimeCost = ObjectCopyUtils.copyProperties(chargeCodePrimeCost,upchargeCodePrimeCost,true);
      }
      return XfR.ok(chargeCodePrimeCostServiceImpl.updateById(upchargeCodePrimeCost));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodeprimecosts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodePrimeCostServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodeprimecosts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_prime_cost");
     params.put("request", condition);

     return XfR.ok(chargeCodePrimeCostServiceImpl.querys(params));
  }

}
