package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.Income;
import com.xforceplus.ultraman.app.financialsettlement.service.IIncomeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 收入表前端控制器
 *
 * @author ultraman
 * @date 2022-01-20
 */
@RestController
public class IncomeController {

  @Autowired
  private IIncomeService incomeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param income 收入表
   * @return
   */
  @GetMapping("/incomes" )
  public XfR getIncomes(XfPage page, Income income) {
    return XfR.ok(incomeServiceImpl.page(page, Wrappers.query(income)));
  }

  /**
   * 通过id查询收入表
   * @param  id
   * @return XfR
   */
  @GetMapping("/incomes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(incomeServiceImpl.getById(id));
  }

  /**
   * 新增收入表
   * @param income 收入表
   * @return XfR
   */
  @PostMapping("/incomes")
  public XfR save(@RequestBody Income income) {
     return XfR.ok(incomeServiceImpl.save(income));
  }

  /**
   * 修改-传入修改后的全部数据收入表
   * @param income 收入表
   * @return XfR
   */
  @PutMapping("/incomes/{id}")
  public XfR putUpdate(@RequestBody Income income,@PathVariable Long id) {
      income.setId(id);
      return XfR.ok(incomeServiceImpl.updateById(income));
  }

  /**
   * 修改-传入修改的数据收入表
   * @param income 收入表
   * @return XfR
   */
  @PatchMapping("/incomes/{id}")
  public XfR patchUpdate(@RequestBody Income income,@PathVariable Long id) {
      Income upincome = incomeServiceImpl.getById(id);
      if(upincome != null){
        upincome = ObjectCopyUtils.copyProperties(income,upincome,true);
      }
      return XfR.ok(incomeServiceImpl.updateById(upincome));
  }

  /**
   * 通过id删除收入表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/incomes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(incomeServiceImpl.removeById(id));
  }

  @PostMapping("/incomes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "income");
     params.put("request", condition);

     return XfR.ok(incomeServiceImpl.querys(params));
  }

}
