package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeCodeBudgetDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IChargeCodeBudgetDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class ChargeCodeBudgetDetailController {

  @Autowired
  private IChargeCodeBudgetDetailService chargeCodeBudgetDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeBudgetDetail ${table.comment}
   * @return
   */
  @GetMapping("/chargecodebudgetdetails" )
  public XfR getChargeCodeBudgetDetails(XfPage page, ChargeCodeBudgetDetail chargeCodeBudgetDetail) {
    return XfR.ok(chargeCodeBudgetDetailServiceImpl.page(page, Wrappers.query(chargeCodeBudgetDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodebudgetdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCodeBudgetDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodebudgetdetails")
  public XfR save(@RequestBody ChargeCodeBudgetDetail chargeCodeBudgetDetail) {
     return XfR.ok(chargeCodeBudgetDetailServiceImpl.save(chargeCodeBudgetDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCodeBudgetDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodebudgetdetails/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeBudgetDetail chargeCodeBudgetDetail,@PathVariable Long id) {
      chargeCodeBudgetDetail.setId(id);
      return XfR.ok(chargeCodeBudgetDetailServiceImpl.updateById(chargeCodeBudgetDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCodeBudgetDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodebudgetdetails/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeBudgetDetail chargeCodeBudgetDetail,@PathVariable Long id) {
      ChargeCodeBudgetDetail upchargeCodeBudgetDetail = chargeCodeBudgetDetailServiceImpl.getById(id);
      if(upchargeCodeBudgetDetail != null){
        upchargeCodeBudgetDetail = ObjectCopyUtils.copyProperties(chargeCodeBudgetDetail,upchargeCodeBudgetDetail,true);
      }
      return XfR.ok(chargeCodeBudgetDetailServiceImpl.updateById(upchargeCodeBudgetDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodebudgetdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetDetailServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodebudgetdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_budget_detail");
     params.put("request", condition);

     return XfR.ok(chargeCodeBudgetDetailServiceImpl.querys(params));
  }

}
