package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.PmsMateData;
import com.xforceplus.ultraman.app.financialsettlement.service.IPmsMateDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class PmsMateDataController {

  @Autowired
  private IPmsMateDataService pmsMateDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pmsMateData ${table.comment}
   * @return
   */
  @GetMapping("/pmsmatedatas" )
  public XfR getPmsMateDatas(XfPage page, PmsMateData pmsMateData) {
    return XfR.ok(pmsMateDataServiceImpl.page(page, Wrappers.query(pmsMateData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pmsmatedatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pmsMateDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pmsMateData ${table.comment}
   * @return XfR
   */
  @PostMapping("/pmsmatedatas")
  public XfR save(@RequestBody PmsMateData pmsMateData) {
     return XfR.ok(pmsMateDataServiceImpl.save(pmsMateData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pmsMateData ${table.comment}
   * @return XfR
   */
  @PutMapping("/pmsmatedatas/{id}")
  public XfR putUpdate(@RequestBody PmsMateData pmsMateData,@PathVariable Long id) {
      pmsMateData.setId(id);
      return XfR.ok(pmsMateDataServiceImpl.updateById(pmsMateData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pmsMateData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pmsmatedatas/{id}")
  public XfR patchUpdate(@RequestBody PmsMateData pmsMateData,@PathVariable Long id) {
      PmsMateData uppmsMateData = pmsMateDataServiceImpl.getById(id);
      if(uppmsMateData != null){
        uppmsMateData = ObjectCopyUtils.copyProperties(pmsMateData,uppmsMateData,true);
      }
      return XfR.ok(pmsMateDataServiceImpl.updateById(uppmsMateData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pmsmatedatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pmsMateDataServiceImpl.removeById(id));
  }

  @PostMapping("/pmsmatedatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pms_mate_data");
     params.put("request", condition);

     return XfR.ok(pmsMateDataServiceImpl.querys(params));
  }

}
