package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeCodePool;
import com.xforceplus.ultraman.app.financialsettlement.service.IChargeCodePoolService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * charegeCode基础信息前端控制器
 *
 * @author ultraman
 * @date 2022-02-16
 */
@RestController
public class ChargeCodePoolController {

  @Autowired
  private IChargeCodePoolService chargeCodePoolServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodePool charegeCode基础信息
   * @return
   */
  @GetMapping("/chargecodepools" )
  public XfR getChargeCodePools(XfPage page, ChargeCodePool chargeCodePool) {
    return XfR.ok(chargeCodePoolServiceImpl.page(page, Wrappers.query(chargeCodePool)));
  }

  /**
   * 通过id查询charegeCode基础信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodepools/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodePoolServiceImpl.getById(id));
  }

  /**
   * 新增charegeCode基础信息
   * @param chargeCodePool charegeCode基础信息
   * @return XfR
   */
  @PostMapping("/chargecodepools")
  public XfR save(@RequestBody ChargeCodePool chargeCodePool) {
     return XfR.ok(chargeCodePoolServiceImpl.save(chargeCodePool));
  }

  /**
   * 修改-传入修改后的全部数据charegeCode基础信息
   * @param chargeCodePool charegeCode基础信息
   * @return XfR
   */
  @PutMapping("/chargecodepools/{id}")
  public XfR putUpdate(@RequestBody ChargeCodePool chargeCodePool,@PathVariable Long id) {
      chargeCodePool.setId(id);
      return XfR.ok(chargeCodePoolServiceImpl.updateById(chargeCodePool));
  }

  /**
   * 修改-传入修改的数据charegeCode基础信息
   * @param chargeCodePool charegeCode基础信息
   * @return XfR
   */
  @PatchMapping("/chargecodepools/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodePool chargeCodePool,@PathVariable Long id) {
      ChargeCodePool upchargeCodePool = chargeCodePoolServiceImpl.getById(id);
      if(upchargeCodePool != null){
        upchargeCodePool = ObjectCopyUtils.copyProperties(chargeCodePool,upchargeCodePool,true);
      }
      return XfR.ok(chargeCodePoolServiceImpl.updateById(upchargeCodePool));
  }

  /**
   * 通过id删除charegeCode基础信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodepools/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodePoolServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodepools/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_pool");
     params.put("request", condition);

     return XfR.ok(chargeCodePoolServiceImpl.querys(params));
  }

}
