package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.JobList;
import com.xforceplus.ultraman.app.financialsettlement.service.IJobListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 定时任务列表前端控制器
 *
 * @author ultraman
 * @date 2022-02-16
 */
@RestController
public class JobListController {

  @Autowired
  private IJobListService jobListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jobList 定时任务列表
   * @return
   */
  @GetMapping("/joblists" )
  public XfR getJobLists(XfPage page, JobList jobList) {
    return XfR.ok(jobListServiceImpl.page(page, Wrappers.query(jobList)));
  }

  /**
   * 通过id查询定时任务列表
   * @param  id
   * @return XfR
   */
  @GetMapping("/joblists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jobListServiceImpl.getById(id));
  }

  /**
   * 新增定时任务列表
   * @param jobList 定时任务列表
   * @return XfR
   */
  @PostMapping("/joblists")
  public XfR save(@RequestBody JobList jobList) {
     return XfR.ok(jobListServiceImpl.save(jobList));
  }

  /**
   * 修改-传入修改后的全部数据定时任务列表
   * @param jobList 定时任务列表
   * @return XfR
   */
  @PutMapping("/joblists/{id}")
  public XfR putUpdate(@RequestBody JobList jobList,@PathVariable Long id) {
      jobList.setId(id);
      return XfR.ok(jobListServiceImpl.updateById(jobList));
  }

  /**
   * 修改-传入修改的数据定时任务列表
   * @param jobList 定时任务列表
   * @return XfR
   */
  @PatchMapping("/joblists/{id}")
  public XfR patchUpdate(@RequestBody JobList jobList,@PathVariable Long id) {
      JobList upjobList = jobListServiceImpl.getById(id);
      if(upjobList != null){
        upjobList = ObjectCopyUtils.copyProperties(jobList,upjobList,true);
      }
      return XfR.ok(jobListServiceImpl.updateById(upjobList));
  }

  /**
   * 通过id删除定时任务列表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/joblists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jobListServiceImpl.removeById(id));
  }

  @PostMapping("/joblists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "job_list");
     params.put("request", condition);

     return XfR.ok(jobListServiceImpl.querys(params));
  }

}
