package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.AllocationByTaxNo;
import com.xforceplus.ultraman.app.financialsettlement.service.IAllocationByTaxNoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-02-17
 */
@RestController
public class AllocationByTaxNoController {

  @Autowired
  private IAllocationByTaxNoService allocationByTaxNoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param allocationByTaxNo ${table.comment}
   * @return
   */
  @GetMapping("/allocationbytaxnos" )
  public XfR getAllocationByTaxNos(XfPage page, AllocationByTaxNo allocationByTaxNo) {
    return XfR.ok(allocationByTaxNoServiceImpl.page(page, Wrappers.query(allocationByTaxNo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/allocationbytaxnos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(allocationByTaxNoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param allocationByTaxNo ${table.comment}
   * @return XfR
   */
  @PostMapping("/allocationbytaxnos")
  public XfR save(@RequestBody AllocationByTaxNo allocationByTaxNo) {
     return XfR.ok(allocationByTaxNoServiceImpl.save(allocationByTaxNo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param allocationByTaxNo ${table.comment}
   * @return XfR
   */
  @PutMapping("/allocationbytaxnos/{id}")
  public XfR putUpdate(@RequestBody AllocationByTaxNo allocationByTaxNo,@PathVariable Long id) {
      allocationByTaxNo.setId(id);
      return XfR.ok(allocationByTaxNoServiceImpl.updateById(allocationByTaxNo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param allocationByTaxNo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/allocationbytaxnos/{id}")
  public XfR patchUpdate(@RequestBody AllocationByTaxNo allocationByTaxNo,@PathVariable Long id) {
      AllocationByTaxNo upallocationByTaxNo = allocationByTaxNoServiceImpl.getById(id);
      if(upallocationByTaxNo != null){
        upallocationByTaxNo = ObjectCopyUtils.copyProperties(allocationByTaxNo,upallocationByTaxNo,true);
      }
      return XfR.ok(allocationByTaxNoServiceImpl.updateById(upallocationByTaxNo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/allocationbytaxnos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(allocationByTaxNoServiceImpl.removeById(id));
  }

  @PostMapping("/allocationbytaxnos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "allocation_by_tax_no");
     params.put("request", condition);

     return XfR.ok(allocationByTaxNoServiceImpl.querys(params));
  }

}
