package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.Costing;
import com.xforceplus.ultraman.app.financialsettlement.service.ICostingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 成本表前端控制器
 *
 * @author ultraman
 * @date 2022-02-18
 */
@RestController
public class CostingController {

  @Autowired
  private ICostingService costingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param costing 成本表
   * @return
   */
  @GetMapping("/costings" )
  public XfR getCostings(XfPage page, Costing costing) {
    return XfR.ok(costingServiceImpl.page(page, Wrappers.query(costing)));
  }

  /**
   * 通过id查询成本表
   * @param  id
   * @return XfR
   */
  @GetMapping("/costings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(costingServiceImpl.getById(id));
  }

  /**
   * 新增成本表
   * @param costing 成本表
   * @return XfR
   */
  @PostMapping("/costings")
  public XfR save(@RequestBody Costing costing) {
     return XfR.ok(costingServiceImpl.save(costing));
  }

  /**
   * 修改-传入修改后的全部数据成本表
   * @param costing 成本表
   * @return XfR
   */
  @PutMapping("/costings/{id}")
  public XfR putUpdate(@RequestBody Costing costing,@PathVariable Long id) {
      costing.setId(id);
      return XfR.ok(costingServiceImpl.updateById(costing));
  }

  /**
   * 修改-传入修改的数据成本表
   * @param costing 成本表
   * @return XfR
   */
  @PatchMapping("/costings/{id}")
  public XfR patchUpdate(@RequestBody Costing costing,@PathVariable Long id) {
      Costing upcosting = costingServiceImpl.getById(id);
      if(upcosting != null){
        upcosting = ObjectCopyUtils.copyProperties(costing,upcosting,true);
      }
      return XfR.ok(costingServiceImpl.updateById(upcosting));
  }

  /**
   * 通过id删除成本表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/costings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(costingServiceImpl.removeById(id));
  }

  @PostMapping("/costings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "costing");
     params.put("request", condition);

     return XfR.ok(costingServiceImpl.querys(params));
  }

}
