package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.Order;
import com.xforceplus.ultraman.app.financialsettlement.service.IOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 订单前端控制器
 *
 * @author ultraman
 * @date 2022-02-23
 */
@RestController
public class OrderController {

  @Autowired
  private IOrderService orderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param order 订单
   * @return
   */
  @GetMapping("/orders" )
  public XfR getOrders(XfPage page, Order order) {
    return XfR.ok(orderServiceImpl.page(page, Wrappers.query(order)));
  }

  /**
   * 通过id查询订单
   * @param  id
   * @return XfR
   */
  @GetMapping("/orders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderServiceImpl.getById(id));
  }

  /**
   * 新增订单
   * @param order 订单
   * @return XfR
   */
  @PostMapping("/orders")
  public XfR save(@RequestBody Order order) {
     return XfR.ok(orderServiceImpl.save(order));
  }

  /**
   * 修改-传入修改后的全部数据订单
   * @param order 订单
   * @return XfR
   */
  @PutMapping("/orders/{id}")
  public XfR putUpdate(@RequestBody Order order,@PathVariable Long id) {
      order.setId(id);
      return XfR.ok(orderServiceImpl.updateById(order));
  }

  /**
   * 修改-传入修改的数据订单
   * @param order 订单
   * @return XfR
   */
  @PatchMapping("/orders/{id}")
  public XfR patchUpdate(@RequestBody Order order,@PathVariable Long id) {
      Order uporder = orderServiceImpl.getById(id);
      if(uporder != null){
        uporder = ObjectCopyUtils.copyProperties(order,uporder,true);
      }
      return XfR.ok(orderServiceImpl.updateById(uporder));
  }

  /**
   * 通过id删除订单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderServiceImpl.removeById(id));
  }

  @PostMapping("/orders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order");
     params.put("request", condition);

     return XfR.ok(orderServiceImpl.querys(params));
  }

}
