package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.OrderInvoiceRelation;
import com.xforceplus.ultraman.app.financialsettlement.service.IOrderInvoiceRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-02-23
 */
@RestController
public class OrderInvoiceRelationController {

  @Autowired
  private IOrderInvoiceRelationService orderInvoiceRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderInvoiceRelation ${table.comment}
   * @return
   */
  @GetMapping("/orderinvoicerelations" )
  public XfR getOrderInvoiceRelations(XfPage page, OrderInvoiceRelation orderInvoiceRelation) {
    return XfR.ok(orderInvoiceRelationServiceImpl.page(page, Wrappers.query(orderInvoiceRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderinvoicerelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderInvoiceRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderInvoiceRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderinvoicerelations")
  public XfR save(@RequestBody OrderInvoiceRelation orderInvoiceRelation) {
     return XfR.ok(orderInvoiceRelationServiceImpl.save(orderInvoiceRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderInvoiceRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderinvoicerelations/{id}")
  public XfR putUpdate(@RequestBody OrderInvoiceRelation orderInvoiceRelation,@PathVariable Long id) {
      orderInvoiceRelation.setId(id);
      return XfR.ok(orderInvoiceRelationServiceImpl.updateById(orderInvoiceRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderInvoiceRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderinvoicerelations/{id}")
  public XfR patchUpdate(@RequestBody OrderInvoiceRelation orderInvoiceRelation,@PathVariable Long id) {
      OrderInvoiceRelation uporderInvoiceRelation = orderInvoiceRelationServiceImpl.getById(id);
      if(uporderInvoiceRelation != null){
        uporderInvoiceRelation = ObjectCopyUtils.copyProperties(orderInvoiceRelation,uporderInvoiceRelation,true);
      }
      return XfR.ok(orderInvoiceRelationServiceImpl.updateById(uporderInvoiceRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderinvoicerelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderInvoiceRelationServiceImpl.removeById(id));
  }

  @PostMapping("/orderinvoicerelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_invoice_relation");
     params.put("request", condition);

     return XfR.ok(orderInvoiceRelationServiceImpl.querys(params));
  }

}
