package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.StatisticBusinessUsage;
import com.xforceplus.ultraman.app.financialsettlement.service.IStatisticBusinessUsageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 结算业务用量统计表前端控制器
 *
 * @author ultraman
 * @date 2022-02-24
 */
@RestController
public class StatisticBusinessUsageController {

  @Autowired
  private IStatisticBusinessUsageService statisticBusinessUsageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param statisticBusinessUsage 结算业务用量统计表
   * @return
   */
  @GetMapping("/statisticbusinessusages" )
  public XfR getStatisticBusinessUsages(XfPage page, StatisticBusinessUsage statisticBusinessUsage) {
    return XfR.ok(statisticBusinessUsageServiceImpl.page(page, Wrappers.query(statisticBusinessUsage)));
  }

  /**
   * 通过id查询结算业务用量统计表
   * @param  id
   * @return XfR
   */
  @GetMapping("/statisticbusinessusages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(statisticBusinessUsageServiceImpl.getById(id));
  }

  /**
   * 新增结算业务用量统计表
   * @param statisticBusinessUsage 结算业务用量统计表
   * @return XfR
   */
  @PostMapping("/statisticbusinessusages")
  public XfR save(@RequestBody StatisticBusinessUsage statisticBusinessUsage) {
     return XfR.ok(statisticBusinessUsageServiceImpl.save(statisticBusinessUsage));
  }

  /**
   * 修改-传入修改后的全部数据结算业务用量统计表
   * @param statisticBusinessUsage 结算业务用量统计表
   * @return XfR
   */
  @PutMapping("/statisticbusinessusages/{id}")
  public XfR putUpdate(@RequestBody StatisticBusinessUsage statisticBusinessUsage,@PathVariable Long id) {
      statisticBusinessUsage.setId(id);
      return XfR.ok(statisticBusinessUsageServiceImpl.updateById(statisticBusinessUsage));
  }

  /**
   * 修改-传入修改的数据结算业务用量统计表
   * @param statisticBusinessUsage 结算业务用量统计表
   * @return XfR
   */
  @PatchMapping("/statisticbusinessusages/{id}")
  public XfR patchUpdate(@RequestBody StatisticBusinessUsage statisticBusinessUsage,@PathVariable Long id) {
      StatisticBusinessUsage upstatisticBusinessUsage = statisticBusinessUsageServiceImpl.getById(id);
      if(upstatisticBusinessUsage != null){
        upstatisticBusinessUsage = ObjectCopyUtils.copyProperties(statisticBusinessUsage,upstatisticBusinessUsage,true);
      }
      return XfR.ok(statisticBusinessUsageServiceImpl.updateById(upstatisticBusinessUsage));
  }

  /**
   * 通过id删除结算业务用量统计表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/statisticbusinessusages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(statisticBusinessUsageServiceImpl.removeById(id));
  }

  @PostMapping("/statisticbusinessusages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "statistic_business_usage");
     params.put("request", condition);

     return XfR.ok(statisticBusinessUsageServiceImpl.querys(params));
  }

}
