package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.Test;
import com.xforceplus.ultraman.app.financialsettlement.service.ITestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 用于测试功能，勿删前端控制器
 *
 * @author ultraman
 * @date 2022-02-24
 */
@RestController
public class TestController {

  @Autowired
  private ITestService testServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test 用于测试功能，勿删
   * @return
   */
  @GetMapping("/tests" )
  public XfR getTests(XfPage page, Test test) {
    return XfR.ok(testServiceImpl.page(page, Wrappers.query(test)));
  }

  /**
   * 通过id查询用于测试功能，勿删
   * @param  id
   * @return XfR
   */
  @GetMapping("/tests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testServiceImpl.getById(id));
  }

  /**
   * 新增用于测试功能，勿删
   * @param test 用于测试功能，勿删
   * @return XfR
   */
  @PostMapping("/tests")
  public XfR save(@RequestBody Test test) {
     return XfR.ok(testServiceImpl.save(test));
  }

  /**
   * 修改-传入修改后的全部数据用于测试功能，勿删
   * @param test 用于测试功能，勿删
   * @return XfR
   */
  @PutMapping("/tests/{id}")
  public XfR putUpdate(@RequestBody Test test,@PathVariable Long id) {
      test.setId(id);
      return XfR.ok(testServiceImpl.updateById(test));
  }

  /**
   * 修改-传入修改的数据用于测试功能，勿删
   * @param test 用于测试功能，勿删
   * @return XfR
   */
  @PatchMapping("/tests/{id}")
  public XfR patchUpdate(@RequestBody Test test,@PathVariable Long id) {
      Test uptest = testServiceImpl.getById(id);
      if(uptest != null){
        uptest = ObjectCopyUtils.copyProperties(test,uptest,true);
      }
      return XfR.ok(testServiceImpl.updateById(uptest));
  }

  /**
   * 通过id删除用于测试功能，勿删
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testServiceImpl.removeById(id));
  }

  @PostMapping("/tests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test");
     params.put("request", condition);

     return XfR.ok(testServiceImpl.querys(params));
  }

}
