package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeCodeMaintain;
import com.xforceplus.ultraman.app.financialsettlement.service.IChargeCodeMaintainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 *  成本编码维护表前端控制器
 *
 * @author ultraman
 * @date 2022-04-11
 */
@RestController
public class ChargeCodeMaintainController {

  @Autowired
  private IChargeCodeMaintainService chargeCodeMaintainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeMaintain  成本编码维护表
   * @return
   */
  @GetMapping("/chargecodemaintains" )
  public XfR getChargeCodeMaintains(XfPage page, ChargeCodeMaintain chargeCodeMaintain) {
    return XfR.ok(chargeCodeMaintainServiceImpl.page(page, Wrappers.query(chargeCodeMaintain)));
  }

  /**
   * 通过id查询 成本编码维护表
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodemaintains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeMaintainServiceImpl.getById(id));
  }

  /**
   * 新增 成本编码维护表
   * @param chargeCodeMaintain  成本编码维护表
   * @return XfR
   */
  @PostMapping("/chargecodemaintains")
  public XfR save(@RequestBody ChargeCodeMaintain chargeCodeMaintain) {
     return XfR.ok(chargeCodeMaintainServiceImpl.save(chargeCodeMaintain));
  }

  /**
   * 修改-传入修改后的全部数据 成本编码维护表
   * @param chargeCodeMaintain  成本编码维护表
   * @return XfR
   */
  @PutMapping("/chargecodemaintains/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeMaintain chargeCodeMaintain,@PathVariable Long id) {
      chargeCodeMaintain.setId(id);
      return XfR.ok(chargeCodeMaintainServiceImpl.updateById(chargeCodeMaintain));
  }

  /**
   * 修改-传入修改的数据 成本编码维护表
   * @param chargeCodeMaintain  成本编码维护表
   * @return XfR
   */
  @PatchMapping("/chargecodemaintains/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeMaintain chargeCodeMaintain,@PathVariable Long id) {
      ChargeCodeMaintain upchargeCodeMaintain = chargeCodeMaintainServiceImpl.getById(id);
      if(upchargeCodeMaintain != null){
        upchargeCodeMaintain = ObjectCopyUtils.copyProperties(chargeCodeMaintain,upchargeCodeMaintain,true);
      }
      return XfR.ok(chargeCodeMaintainServiceImpl.updateById(upchargeCodeMaintain));
  }

  /**
   * 通过id删除 成本编码维护表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodemaintains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeMaintainServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodemaintains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_maintain");
     params.put("request", condition);

     return XfR.ok(chargeCodeMaintainServiceImpl.querys(params));
  }

}
