package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.InfoBI;
import com.xforceplus.ultraman.app.financialsettlement.service.IInfoBIService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 用量前端控制器
 *
 * @author ultraman
 * @date 2022-04-11
 */
@RestController
public class InfoBIController {

  @Autowired
  private IInfoBIService infoBIServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param infoBI 用量
   * @return
   */
  @GetMapping("/infobis" )
  public XfR getInfoBIs(XfPage page, InfoBI infoBI) {
    return XfR.ok(infoBIServiceImpl.page(page, Wrappers.query(infoBI)));
  }

  /**
   * 通过id查询用量
   * @param  id
   * @return XfR
   */
  @GetMapping("/infobis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(infoBIServiceImpl.getById(id));
  }

  /**
   * 新增用量
   * @param infoBI 用量
   * @return XfR
   */
  @PostMapping("/infobis")
  public XfR save(@RequestBody InfoBI infoBI) {
     return XfR.ok(infoBIServiceImpl.save(infoBI));
  }

  /**
   * 修改-传入修改后的全部数据用量
   * @param infoBI 用量
   * @return XfR
   */
  @PutMapping("/infobis/{id}")
  public XfR putUpdate(@RequestBody InfoBI infoBI,@PathVariable Long id) {
      infoBI.setId(id);
      return XfR.ok(infoBIServiceImpl.updateById(infoBI));
  }

  /**
   * 修改-传入修改的数据用量
   * @param infoBI 用量
   * @return XfR
   */
  @PatchMapping("/infobis/{id}")
  public XfR patchUpdate(@RequestBody InfoBI infoBI,@PathVariable Long id) {
      InfoBI upinfoBI = infoBIServiceImpl.getById(id);
      if(upinfoBI != null){
        upinfoBI = ObjectCopyUtils.copyProperties(infoBI,upinfoBI,true);
      }
      return XfR.ok(infoBIServiceImpl.updateById(upinfoBI));
  }

  /**
   * 通过id删除用量
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/infobis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(infoBIServiceImpl.removeById(id));
  }

  @PostMapping("/infobis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "info_b_i");
     params.put("request", condition);

     return XfR.ok(infoBIServiceImpl.querys(params));
  }

}
