package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ReconciliationDetailData;
import com.xforceplus.ultraman.app.financialsettlement.service.IReconciliationDetailDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 对账单明细-(废弃)前端控制器
 *
 * @author ultraman
 * @date 2022-04-11
 */
@RestController
public class ReconciliationDetailDataController {

  @Autowired
  private IReconciliationDetailDataService reconciliationDetailDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconciliationDetailData 对账单明细-(废弃)
   * @return
   */
  @GetMapping("/reconciliationdetaildatas" )
  public XfR getReconciliationDetailDatas(XfPage page, ReconciliationDetailData reconciliationDetailData) {
    return XfR.ok(reconciliationDetailDataServiceImpl.page(page, Wrappers.query(reconciliationDetailData)));
  }

  /**
   * 通过id查询对账单明细-(废弃)
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconciliationdetaildatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconciliationDetailDataServiceImpl.getById(id));
  }

  /**
   * 新增对账单明细-(废弃)
   * @param reconciliationDetailData 对账单明细-(废弃)
   * @return XfR
   */
  @PostMapping("/reconciliationdetaildatas")
  public XfR save(@RequestBody ReconciliationDetailData reconciliationDetailData) {
     return XfR.ok(reconciliationDetailDataServiceImpl.save(reconciliationDetailData));
  }

  /**
   * 修改-传入修改后的全部数据对账单明细-(废弃)
   * @param reconciliationDetailData 对账单明细-(废弃)
   * @return XfR
   */
  @PutMapping("/reconciliationdetaildatas/{id}")
  public XfR putUpdate(@RequestBody ReconciliationDetailData reconciliationDetailData,@PathVariable Long id) {
      reconciliationDetailData.setId(id);
      return XfR.ok(reconciliationDetailDataServiceImpl.updateById(reconciliationDetailData));
  }

  /**
   * 修改-传入修改的数据对账单明细-(废弃)
   * @param reconciliationDetailData 对账单明细-(废弃)
   * @return XfR
   */
  @PatchMapping("/reconciliationdetaildatas/{id}")
  public XfR patchUpdate(@RequestBody ReconciliationDetailData reconciliationDetailData,@PathVariable Long id) {
      ReconciliationDetailData upreconciliationDetailData = reconciliationDetailDataServiceImpl.getById(id);
      if(upreconciliationDetailData != null){
        upreconciliationDetailData = ObjectCopyUtils.copyProperties(reconciliationDetailData,upreconciliationDetailData,true);
      }
      return XfR.ok(reconciliationDetailDataServiceImpl.updateById(upreconciliationDetailData));
  }

  /**
   * 通过id删除对账单明细-(废弃)
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconciliationdetaildatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconciliationDetailDataServiceImpl.removeById(id));
  }

  @PostMapping("/reconciliationdetaildatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "reconciliation_detail_data");
     params.put("request", condition);

     return XfR.ok(reconciliationDetailDataServiceImpl.querys(params));
  }

}
