package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.OrderInfoRawData;
import com.xforceplus.ultraman.app.financialsettlement.service.IOrderInfoRawDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-04-24
 */
@RestController
public class OrderInfoRawDataController {

  @Autowired
  private IOrderInfoRawDataService orderInfoRawDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderInfoRawData ${table.comment}
   * @return
   */
  @GetMapping("/orderinforawdatas" )
  public XfR getOrderInfoRawDatas(XfPage page, OrderInfoRawData orderInfoRawData) {
    return XfR.ok(orderInfoRawDataServiceImpl.page(page, Wrappers.query(orderInfoRawData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderinforawdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderInfoRawDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderInfoRawData ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderinforawdatas")
  public XfR save(@RequestBody OrderInfoRawData orderInfoRawData) {
     return XfR.ok(orderInfoRawDataServiceImpl.save(orderInfoRawData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderInfoRawData ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderinforawdatas/{id}")
  public XfR putUpdate(@RequestBody OrderInfoRawData orderInfoRawData,@PathVariable Long id) {
      orderInfoRawData.setId(id);
      return XfR.ok(orderInfoRawDataServiceImpl.updateById(orderInfoRawData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderInfoRawData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderinforawdatas/{id}")
  public XfR patchUpdate(@RequestBody OrderInfoRawData orderInfoRawData,@PathVariable Long id) {
      OrderInfoRawData uporderInfoRawData = orderInfoRawDataServiceImpl.getById(id);
      if(uporderInfoRawData != null){
        uporderInfoRawData = ObjectCopyUtils.copyProperties(orderInfoRawData,uporderInfoRawData,true);
      }
      return XfR.ok(orderInfoRawDataServiceImpl.updateById(uporderInfoRawData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderinforawdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderInfoRawDataServiceImpl.removeById(id));
  }

  @PostMapping("/orderinforawdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_info_raw_data");
     params.put("request", condition);

     return XfR.ok(orderInfoRawDataServiceImpl.querys(params));
  }

}
