package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ReceivedPaymentsTaken;
import com.xforceplus.ultraman.app.financialsettlement.service.IReceivedPaymentsTakenService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-05-20
 */
@RestController
public class ReceivedPaymentsTakenController {

  @Autowired
  private IReceivedPaymentsTakenService receivedPaymentsTakenServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receivedPaymentsTaken ${table.comment}
   * @return
   */
  @GetMapping("/receivedpaymentstakens" )
  public XfR getReceivedPaymentsTakens(XfPage page, ReceivedPaymentsTaken receivedPaymentsTaken) {
    return XfR.ok(receivedPaymentsTakenServiceImpl.page(page, Wrappers.query(receivedPaymentsTaken)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivedpaymentstakens/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receivedPaymentsTakenServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param receivedPaymentsTaken ${table.comment}
   * @return XfR
   */
  @PostMapping("/receivedpaymentstakens")
  public XfR save(@RequestBody ReceivedPaymentsTaken receivedPaymentsTaken) {
     return XfR.ok(receivedPaymentsTakenServiceImpl.save(receivedPaymentsTaken));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param receivedPaymentsTaken ${table.comment}
   * @return XfR
   */
  @PutMapping("/receivedpaymentstakens/{id}")
  public XfR putUpdate(@RequestBody ReceivedPaymentsTaken receivedPaymentsTaken,@PathVariable Long id) {
      receivedPaymentsTaken.setId(id);
      return XfR.ok(receivedPaymentsTakenServiceImpl.updateById(receivedPaymentsTaken));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param receivedPaymentsTaken ${table.comment}
   * @return XfR
   */
  @PatchMapping("/receivedpaymentstakens/{id}")
  public XfR patchUpdate(@RequestBody ReceivedPaymentsTaken receivedPaymentsTaken,@PathVariable Long id) {
      ReceivedPaymentsTaken upreceivedPaymentsTaken = receivedPaymentsTakenServiceImpl.getById(id);
      if(upreceivedPaymentsTaken != null){
        upreceivedPaymentsTaken = ObjectCopyUtils.copyProperties(receivedPaymentsTaken,upreceivedPaymentsTaken,true);
      }
      return XfR.ok(receivedPaymentsTakenServiceImpl.updateById(upreceivedPaymentsTaken));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivedpaymentstakens/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receivedPaymentsTakenServiceImpl.removeById(id));
  }

  @PostMapping("/receivedpaymentstakens/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "received_payments_taken");
     params.put("request", condition);

     return XfR.ok(receivedPaymentsTakenServiceImpl.querys(params));
  }

}
