package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.BusinessServeBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IBusinessServeBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 业务招待报销单明细前端控制器
 *
 * @author ultraman
 * @date 2022-05-25
 */
@RestController
public class BusinessServeBillDetailController {

  @Autowired
  private IBusinessServeBillDetailService businessServeBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessServeBillDetail 业务招待报销单明细
   * @return
   */
  @GetMapping("/businessservebilldetails" )
  public XfR getBusinessServeBillDetails(XfPage page, BusinessServeBillDetail businessServeBillDetail) {
    return XfR.ok(businessServeBillDetailServiceImpl.page(page, Wrappers.query(businessServeBillDetail)));
  }

  /**
   * 通过id查询业务招待报销单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessservebilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessServeBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增业务招待报销单明细
   * @param businessServeBillDetail 业务招待报销单明细
   * @return XfR
   */
  @PostMapping("/businessservebilldetails")
  public XfR save(@RequestBody BusinessServeBillDetail businessServeBillDetail) {
     return XfR.ok(businessServeBillDetailServiceImpl.save(businessServeBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据业务招待报销单明细
   * @param businessServeBillDetail 业务招待报销单明细
   * @return XfR
   */
  @PutMapping("/businessservebilldetails/{id}")
  public XfR putUpdate(@RequestBody BusinessServeBillDetail businessServeBillDetail,@PathVariable Long id) {
      businessServeBillDetail.setId(id);
      return XfR.ok(businessServeBillDetailServiceImpl.updateById(businessServeBillDetail));
  }

  /**
   * 修改-传入修改的数据业务招待报销单明细
   * @param businessServeBillDetail 业务招待报销单明细
   * @return XfR
   */
  @PatchMapping("/businessservebilldetails/{id}")
  public XfR patchUpdate(@RequestBody BusinessServeBillDetail businessServeBillDetail,@PathVariable Long id) {
      BusinessServeBillDetail upbusinessServeBillDetail = businessServeBillDetailServiceImpl.getById(id);
      if(upbusinessServeBillDetail != null){
        upbusinessServeBillDetail = ObjectCopyUtils.copyProperties(businessServeBillDetail,upbusinessServeBillDetail,true);
      }
      return XfR.ok(businessServeBillDetailServiceImpl.updateById(upbusinessServeBillDetail));
  }

  /**
   * 通过id删除业务招待报销单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessservebilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessServeBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/businessservebilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_serve_bill_detail");
     params.put("request", condition);

     return XfR.ok(businessServeBillDetailServiceImpl.querys(params));
  }

}
