package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.BusinessServeReimbursementBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IBusinessServeReimbursementBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 业务招待报销单前端控制器
 *
 * @author ultraman
 * @date 2022-05-25
 */
@RestController
public class BusinessServeReimbursementBillController {

  @Autowired
  private IBusinessServeReimbursementBillService businessServeReimbursementBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessServeReimbursementBill 业务招待报销单
   * @return
   */
  @GetMapping("/businessservereimbursementbills" )
  public XfR getBusinessServeReimbursementBills(XfPage page, BusinessServeReimbursementBill businessServeReimbursementBill) {
    return XfR.ok(businessServeReimbursementBillServiceImpl.page(page, Wrappers.query(businessServeReimbursementBill)));
  }

  /**
   * 通过id查询业务招待报销单
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessservereimbursementbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessServeReimbursementBillServiceImpl.getById(id));
  }

  /**
   * 新增业务招待报销单
   * @param businessServeReimbursementBill 业务招待报销单
   * @return XfR
   */
  @PostMapping("/businessservereimbursementbills")
  public XfR save(@RequestBody BusinessServeReimbursementBill businessServeReimbursementBill) {
     return XfR.ok(businessServeReimbursementBillServiceImpl.save(businessServeReimbursementBill));
  }

  /**
   * 修改-传入修改后的全部数据业务招待报销单
   * @param businessServeReimbursementBill 业务招待报销单
   * @return XfR
   */
  @PutMapping("/businessservereimbursementbills/{id}")
  public XfR putUpdate(@RequestBody BusinessServeReimbursementBill businessServeReimbursementBill,@PathVariable Long id) {
      businessServeReimbursementBill.setId(id);
      return XfR.ok(businessServeReimbursementBillServiceImpl.updateById(businessServeReimbursementBill));
  }

  /**
   * 修改-传入修改的数据业务招待报销单
   * @param businessServeReimbursementBill 业务招待报销单
   * @return XfR
   */
  @PatchMapping("/businessservereimbursementbills/{id}")
  public XfR patchUpdate(@RequestBody BusinessServeReimbursementBill businessServeReimbursementBill,@PathVariable Long id) {
      BusinessServeReimbursementBill upbusinessServeReimbursementBill = businessServeReimbursementBillServiceImpl.getById(id);
      if(upbusinessServeReimbursementBill != null){
        upbusinessServeReimbursementBill = ObjectCopyUtils.copyProperties(businessServeReimbursementBill,upbusinessServeReimbursementBill,true);
      }
      return XfR.ok(businessServeReimbursementBillServiceImpl.updateById(upbusinessServeReimbursementBill));
  }

  /**
   * 通过id删除业务招待报销单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessservereimbursementbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessServeReimbursementBillServiceImpl.removeById(id));
  }

  @PostMapping("/businessservereimbursementbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_serve_reimbursement_bill");
     params.put("request", condition);

     return XfR.ok(businessServeReimbursementBillServiceImpl.querys(params));
  }

}
