package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.CityReimbursementBill;
import com.xforceplus.ultraman.app.financialsettlement.service.ICityReimbursementBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-05-25
 */
@RestController
public class CityReimbursementBillController {

  @Autowired
  private ICityReimbursementBillService cityReimbursementBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cityReimbursementBill ${table.comment}
   * @return
   */
  @GetMapping("/cityreimbursementbills" )
  public XfR getCityReimbursementBills(XfPage page, CityReimbursementBill cityReimbursementBill) {
    return XfR.ok(cityReimbursementBillServiceImpl.page(page, Wrappers.query(cityReimbursementBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/cityreimbursementbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(cityReimbursementBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param cityReimbursementBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/cityreimbursementbills")
  public XfR save(@RequestBody CityReimbursementBill cityReimbursementBill) {
     return XfR.ok(cityReimbursementBillServiceImpl.save(cityReimbursementBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param cityReimbursementBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/cityreimbursementbills/{id}")
  public XfR putUpdate(@RequestBody CityReimbursementBill cityReimbursementBill,@PathVariable Long id) {
      cityReimbursementBill.setId(id);
      return XfR.ok(cityReimbursementBillServiceImpl.updateById(cityReimbursementBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param cityReimbursementBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/cityreimbursementbills/{id}")
  public XfR patchUpdate(@RequestBody CityReimbursementBill cityReimbursementBill,@PathVariable Long id) {
      CityReimbursementBill upcityReimbursementBill = cityReimbursementBillServiceImpl.getById(id);
      if(upcityReimbursementBill != null){
        upcityReimbursementBill = ObjectCopyUtils.copyProperties(cityReimbursementBill,upcityReimbursementBill,true);
      }
      return XfR.ok(cityReimbursementBillServiceImpl.updateById(upcityReimbursementBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cityreimbursementbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(cityReimbursementBillServiceImpl.removeById(id));
  }

  @PostMapping("/cityreimbursementbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "city_reimbursement_bill");
     params.put("request", condition);

     return XfR.ok(cityReimbursementBillServiceImpl.querys(params));
  }

}
