package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinBasicBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinBasicBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 财务基础单据前端控制器
 *
 * @author ultraman
 * @date 2022-05-25
 */
@RestController
public class FinBasicBillController {

  @Autowired
  private IFinBasicBillService finBasicBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param finBasicBill 财务基础单据
   * @return
   */
  @GetMapping("/finbasicbills" )
  public XfR getFinBasicBills(XfPage page, FinBasicBill finBasicBill) {
    return XfR.ok(finBasicBillServiceImpl.page(page, Wrappers.query(finBasicBill)));
  }

  /**
   * 通过id查询财务基础单据
   * @param  id
   * @return XfR
   */
  @GetMapping("/finbasicbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(finBasicBillServiceImpl.getById(id));
  }

  /**
   * 新增财务基础单据
   * @param finBasicBill 财务基础单据
   * @return XfR
   */
  @PostMapping("/finbasicbills")
  public XfR save(@RequestBody FinBasicBill finBasicBill) {
     return XfR.ok(finBasicBillServiceImpl.save(finBasicBill));
  }

  /**
   * 修改-传入修改后的全部数据财务基础单据
   * @param finBasicBill 财务基础单据
   * @return XfR
   */
  @PutMapping("/finbasicbills/{id}")
  public XfR putUpdate(@RequestBody FinBasicBill finBasicBill,@PathVariable Long id) {
      finBasicBill.setId(id);
      return XfR.ok(finBasicBillServiceImpl.updateById(finBasicBill));
  }

  /**
   * 修改-传入修改的数据财务基础单据
   * @param finBasicBill 财务基础单据
   * @return XfR
   */
  @PatchMapping("/finbasicbills/{id}")
  public XfR patchUpdate(@RequestBody FinBasicBill finBasicBill,@PathVariable Long id) {
      FinBasicBill upfinBasicBill = finBasicBillServiceImpl.getById(id);
      if(upfinBasicBill != null){
        upfinBasicBill = ObjectCopyUtils.copyProperties(finBasicBill,upfinBasicBill,true);
      }
      return XfR.ok(finBasicBillServiceImpl.updateById(upfinBasicBill));
  }

  /**
   * 通过id删除财务基础单据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/finbasicbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(finBasicBillServiceImpl.removeById(id));
  }

  @PostMapping("/finbasicbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fin_basic_bill");
     params.put("request", condition);

     return XfR.ok(finBasicBillServiceImpl.querys(params));
  }

}
