package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ShareInfo;
import com.xforceplus.ultraman.app.financialsettlement.service.IShareInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 分摊信息前端控制器
 *
 * @author ultraman
 * @date 2022-05-25
 */
@RestController
public class ShareInfoController {

  @Autowired
  private IShareInfoService shareInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param shareInfo 分摊信息
   * @return
   */
  @GetMapping("/shareinfos" )
  public XfR getShareInfos(XfPage page, ShareInfo shareInfo) {
    return XfR.ok(shareInfoServiceImpl.page(page, Wrappers.query(shareInfo)));
  }

  /**
   * 通过id查询分摊信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/shareinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(shareInfoServiceImpl.getById(id));
  }

  /**
   * 新增分摊信息
   * @param shareInfo 分摊信息
   * @return XfR
   */
  @PostMapping("/shareinfos")
  public XfR save(@RequestBody ShareInfo shareInfo) {
     return XfR.ok(shareInfoServiceImpl.save(shareInfo));
  }

  /**
   * 修改-传入修改后的全部数据分摊信息
   * @param shareInfo 分摊信息
   * @return XfR
   */
  @PutMapping("/shareinfos/{id}")
  public XfR putUpdate(@RequestBody ShareInfo shareInfo,@PathVariable Long id) {
      shareInfo.setId(id);
      return XfR.ok(shareInfoServiceImpl.updateById(shareInfo));
  }

  /**
   * 修改-传入修改的数据分摊信息
   * @param shareInfo 分摊信息
   * @return XfR
   */
  @PatchMapping("/shareinfos/{id}")
  public XfR patchUpdate(@RequestBody ShareInfo shareInfo,@PathVariable Long id) {
      ShareInfo upshareInfo = shareInfoServiceImpl.getById(id);
      if(upshareInfo != null){
        upshareInfo = ObjectCopyUtils.copyProperties(shareInfo,upshareInfo,true);
      }
      return XfR.ok(shareInfoServiceImpl.updateById(upshareInfo));
  }

  /**
   * 通过id删除分摊信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/shareinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(shareInfoServiceImpl.removeById(id));
  }

  @PostMapping("/shareinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "share_info");
     params.put("request", condition);

     return XfR.ok(shareInfoServiceImpl.querys(params));
  }

}
