package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.TravelApplyBill;
import com.xforceplus.ultraman.app.financialsettlement.service.ITravelApplyBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 差旅申请单前端控制器
 *
 * @author ultraman
 * @date 2022-05-25
 */
@RestController
public class TravelApplyBillController {

  @Autowired
  private ITravelApplyBillService travelApplyBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param travelApplyBill 差旅申请单
   * @return
   */
  @GetMapping("/travelapplybills" )
  public XfR getTravelApplyBills(XfPage page, TravelApplyBill travelApplyBill) {
    return XfR.ok(travelApplyBillServiceImpl.page(page, Wrappers.query(travelApplyBill)));
  }

  /**
   * 通过id查询差旅申请单
   * @param  id
   * @return XfR
   */
  @GetMapping("/travelapplybills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(travelApplyBillServiceImpl.getById(id));
  }

  /**
   * 新增差旅申请单
   * @param travelApplyBill 差旅申请单
   * @return XfR
   */
  @PostMapping("/travelapplybills")
  public XfR save(@RequestBody TravelApplyBill travelApplyBill) {
     return XfR.ok(travelApplyBillServiceImpl.save(travelApplyBill));
  }

  /**
   * 修改-传入修改后的全部数据差旅申请单
   * @param travelApplyBill 差旅申请单
   * @return XfR
   */
  @PutMapping("/travelapplybills/{id}")
  public XfR putUpdate(@RequestBody TravelApplyBill travelApplyBill,@PathVariable Long id) {
      travelApplyBill.setId(id);
      return XfR.ok(travelApplyBillServiceImpl.updateById(travelApplyBill));
  }

  /**
   * 修改-传入修改的数据差旅申请单
   * @param travelApplyBill 差旅申请单
   * @return XfR
   */
  @PatchMapping("/travelapplybills/{id}")
  public XfR patchUpdate(@RequestBody TravelApplyBill travelApplyBill,@PathVariable Long id) {
      TravelApplyBill uptravelApplyBill = travelApplyBillServiceImpl.getById(id);
      if(uptravelApplyBill != null){
        uptravelApplyBill = ObjectCopyUtils.copyProperties(travelApplyBill,uptravelApplyBill,true);
      }
      return XfR.ok(travelApplyBillServiceImpl.updateById(uptravelApplyBill));
  }

  /**
   * 通过id删除差旅申请单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/travelapplybills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(travelApplyBillServiceImpl.removeById(id));
  }

  @PostMapping("/travelapplybills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "travel_apply_bill");
     params.put("request", condition);

     return XfR.ok(travelApplyBillServiceImpl.querys(params));
  }

}
