package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ApplyBasicBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IApplyBasicBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 申请基础单据前端控制器
 *
 * @author ultraman
 * @date 2022-06-08
 */
@RestController
public class ApplyBasicBillController {

  @Autowired
  private IApplyBasicBillService applyBasicBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param applyBasicBill 申请基础单据
   * @return
   */
  @GetMapping("/applybasicbills" )
  public XfR getApplyBasicBills(XfPage page, ApplyBasicBill applyBasicBill) {
    return XfR.ok(applyBasicBillServiceImpl.page(page, Wrappers.query(applyBasicBill)));
  }

  /**
   * 通过id查询申请基础单据
   * @param  id
   * @return XfR
   */
  @GetMapping("/applybasicbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(applyBasicBillServiceImpl.getById(id));
  }

  /**
   * 新增申请基础单据
   * @param applyBasicBill 申请基础单据
   * @return XfR
   */
  @PostMapping("/applybasicbills")
  public XfR save(@RequestBody ApplyBasicBill applyBasicBill) {
     return XfR.ok(applyBasicBillServiceImpl.save(applyBasicBill));
  }

  /**
   * 修改-传入修改后的全部数据申请基础单据
   * @param applyBasicBill 申请基础单据
   * @return XfR
   */
  @PutMapping("/applybasicbills/{id}")
  public XfR putUpdate(@RequestBody ApplyBasicBill applyBasicBill,@PathVariable Long id) {
      applyBasicBill.setId(id);
      return XfR.ok(applyBasicBillServiceImpl.updateById(applyBasicBill));
  }

  /**
   * 修改-传入修改的数据申请基础单据
   * @param applyBasicBill 申请基础单据
   * @return XfR
   */
  @PatchMapping("/applybasicbills/{id}")
  public XfR patchUpdate(@RequestBody ApplyBasicBill applyBasicBill,@PathVariable Long id) {
      ApplyBasicBill upapplyBasicBill = applyBasicBillServiceImpl.getById(id);
      if(upapplyBasicBill != null){
        upapplyBasicBill = ObjectCopyUtils.copyProperties(applyBasicBill,upapplyBasicBill,true);
      }
      return XfR.ok(applyBasicBillServiceImpl.updateById(upapplyBasicBill));
  }

  /**
   * 通过id删除申请基础单据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/applybasicbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(applyBasicBillServiceImpl.removeById(id));
  }

  @PostMapping("/applybasicbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "apply_basic_bill");
     params.put("request", condition);

     return XfR.ok(applyBasicBillServiceImpl.querys(params));
  }

}
