package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.BillDetailMonth;
import com.xforceplus.ultraman.app.financialsettlement.service.IBillDetailMonthService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-08
 */
@RestController
public class BillDetailMonthController {

  @Autowired
  private IBillDetailMonthService billDetailMonthServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billDetailMonth ${table.comment}
   * @return
   */
  @GetMapping("/billdetailmonths" )
  public XfR getBillDetailMonths(XfPage page, BillDetailMonth billDetailMonth) {
    return XfR.ok(billDetailMonthServiceImpl.page(page, Wrappers.query(billDetailMonth)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billdetailmonths/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billDetailMonthServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billDetailMonth ${table.comment}
   * @return XfR
   */
  @PostMapping("/billdetailmonths")
  public XfR save(@RequestBody BillDetailMonth billDetailMonth) {
     return XfR.ok(billDetailMonthServiceImpl.save(billDetailMonth));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billDetailMonth ${table.comment}
   * @return XfR
   */
  @PutMapping("/billdetailmonths/{id}")
  public XfR putUpdate(@RequestBody BillDetailMonth billDetailMonth,@PathVariable Long id) {
      billDetailMonth.setId(id);
      return XfR.ok(billDetailMonthServiceImpl.updateById(billDetailMonth));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billDetailMonth ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billdetailmonths/{id}")
  public XfR patchUpdate(@RequestBody BillDetailMonth billDetailMonth,@PathVariable Long id) {
      BillDetailMonth upbillDetailMonth = billDetailMonthServiceImpl.getById(id);
      if(upbillDetailMonth != null){
        upbillDetailMonth = ObjectCopyUtils.copyProperties(billDetailMonth,upbillDetailMonth,true);
      }
      return XfR.ok(billDetailMonthServiceImpl.updateById(upbillDetailMonth));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billdetailmonths/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billDetailMonthServiceImpl.removeById(id));
  }

  @PostMapping("/billdetailmonths/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_detail_month");
     params.put("request", condition);

     return XfR.ok(billDetailMonthServiceImpl.querys(params));
  }

}
