package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinBasicBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinBasicBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 财务基础单据明细前端控制器
 *
 * @author ultraman
 * @date 2022-06-08
 */
@RestController
public class FinBasicBillDetailController {

  @Autowired
  private IFinBasicBillDetailService finBasicBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param finBasicBillDetail 财务基础单据明细
   * @return
   */
  @GetMapping("/finbasicbilldetails" )
  public XfR getFinBasicBillDetails(XfPage page, FinBasicBillDetail finBasicBillDetail) {
    return XfR.ok(finBasicBillDetailServiceImpl.page(page, Wrappers.query(finBasicBillDetail)));
  }

  /**
   * 通过id查询财务基础单据明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/finbasicbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(finBasicBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增财务基础单据明细
   * @param finBasicBillDetail 财务基础单据明细
   * @return XfR
   */
  @PostMapping("/finbasicbilldetails")
  public XfR save(@RequestBody FinBasicBillDetail finBasicBillDetail) {
     return XfR.ok(finBasicBillDetailServiceImpl.save(finBasicBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据财务基础单据明细
   * @param finBasicBillDetail 财务基础单据明细
   * @return XfR
   */
  @PutMapping("/finbasicbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinBasicBillDetail finBasicBillDetail,@PathVariable Long id) {
      finBasicBillDetail.setId(id);
      return XfR.ok(finBasicBillDetailServiceImpl.updateById(finBasicBillDetail));
  }

  /**
   * 修改-传入修改的数据财务基础单据明细
   * @param finBasicBillDetail 财务基础单据明细
   * @return XfR
   */
  @PatchMapping("/finbasicbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinBasicBillDetail finBasicBillDetail,@PathVariable Long id) {
      FinBasicBillDetail upfinBasicBillDetail = finBasicBillDetailServiceImpl.getById(id);
      if(upfinBasicBillDetail != null){
        upfinBasicBillDetail = ObjectCopyUtils.copyProperties(finBasicBillDetail,upfinBasicBillDetail,true);
      }
      return XfR.ok(finBasicBillDetailServiceImpl.updateById(upfinBasicBillDetail));
  }

  /**
   * 通过id删除财务基础单据明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/finbasicbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(finBasicBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/finbasicbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fin_basic_bill_detail");
     params.put("request", condition);

     return XfR.ok(finBasicBillDetailServiceImpl.querys(params));
  }

}
