package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.HesWriteoffBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IHesWriteoffBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 合思订单核销单前端控制器
 *
 * @author ultraman
 * @date 2022-06-08
 */
@RestController
public class HesWriteoffBillController {

  @Autowired
  private IHesWriteoffBillService hesWriteoffBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param hesWriteoffBill 合思订单核销单
   * @return
   */
  @GetMapping("/heswriteoffbills" )
  public XfR getHesWriteoffBills(XfPage page, HesWriteoffBill hesWriteoffBill) {
    return XfR.ok(hesWriteoffBillServiceImpl.page(page, Wrappers.query(hesWriteoffBill)));
  }

  /**
   * 通过id查询合思订单核销单
   * @param  id
   * @return XfR
   */
  @GetMapping("/heswriteoffbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(hesWriteoffBillServiceImpl.getById(id));
  }

  /**
   * 新增合思订单核销单
   * @param hesWriteoffBill 合思订单核销单
   * @return XfR
   */
  @PostMapping("/heswriteoffbills")
  public XfR save(@RequestBody HesWriteoffBill hesWriteoffBill) {
     return XfR.ok(hesWriteoffBillServiceImpl.save(hesWriteoffBill));
  }

  /**
   * 修改-传入修改后的全部数据合思订单核销单
   * @param hesWriteoffBill 合思订单核销单
   * @return XfR
   */
  @PutMapping("/heswriteoffbills/{id}")
  public XfR putUpdate(@RequestBody HesWriteoffBill hesWriteoffBill,@PathVariable Long id) {
      hesWriteoffBill.setId(id);
      return XfR.ok(hesWriteoffBillServiceImpl.updateById(hesWriteoffBill));
  }

  /**
   * 修改-传入修改的数据合思订单核销单
   * @param hesWriteoffBill 合思订单核销单
   * @return XfR
   */
  @PatchMapping("/heswriteoffbills/{id}")
  public XfR patchUpdate(@RequestBody HesWriteoffBill hesWriteoffBill,@PathVariable Long id) {
      HesWriteoffBill uphesWriteoffBill = hesWriteoffBillServiceImpl.getById(id);
      if(uphesWriteoffBill != null){
        uphesWriteoffBill = ObjectCopyUtils.copyProperties(hesWriteoffBill,uphesWriteoffBill,true);
      }
      return XfR.ok(hesWriteoffBillServiceImpl.updateById(uphesWriteoffBill));
  }

  /**
   * 通过id删除合思订单核销单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/heswriteoffbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(hesWriteoffBillServiceImpl.removeById(id));
  }

  @PostMapping("/heswriteoffbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "hes_writeoff_bill");
     params.put("request", condition);

     return XfR.ok(hesWriteoffBillServiceImpl.querys(params));
  }

}
