package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ReimbursementBasicBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IReimbursementBasicBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 报销基础单据前端控制器
 *
 * @author ultraman
 * @date 2022-06-08
 */
@RestController
public class ReimbursementBasicBillController {

  @Autowired
  private IReimbursementBasicBillService reimbursementBasicBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reimbursementBasicBill 报销基础单据
   * @return
   */
  @GetMapping("/reimbursementbasicbills" )
  public XfR getReimbursementBasicBills(XfPage page, ReimbursementBasicBill reimbursementBasicBill) {
    return XfR.ok(reimbursementBasicBillServiceImpl.page(page, Wrappers.query(reimbursementBasicBill)));
  }

  /**
   * 通过id查询报销基础单据
   * @param  id
   * @return XfR
   */
  @GetMapping("/reimbursementbasicbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reimbursementBasicBillServiceImpl.getById(id));
  }

  /**
   * 新增报销基础单据
   * @param reimbursementBasicBill 报销基础单据
   * @return XfR
   */
  @PostMapping("/reimbursementbasicbills")
  public XfR save(@RequestBody ReimbursementBasicBill reimbursementBasicBill) {
     return XfR.ok(reimbursementBasicBillServiceImpl.save(reimbursementBasicBill));
  }

  /**
   * 修改-传入修改后的全部数据报销基础单据
   * @param reimbursementBasicBill 报销基础单据
   * @return XfR
   */
  @PutMapping("/reimbursementbasicbills/{id}")
  public XfR putUpdate(@RequestBody ReimbursementBasicBill reimbursementBasicBill,@PathVariable Long id) {
      reimbursementBasicBill.setId(id);
      return XfR.ok(reimbursementBasicBillServiceImpl.updateById(reimbursementBasicBill));
  }

  /**
   * 修改-传入修改的数据报销基础单据
   * @param reimbursementBasicBill 报销基础单据
   * @return XfR
   */
  @PatchMapping("/reimbursementbasicbills/{id}")
  public XfR patchUpdate(@RequestBody ReimbursementBasicBill reimbursementBasicBill,@PathVariable Long id) {
      ReimbursementBasicBill upreimbursementBasicBill = reimbursementBasicBillServiceImpl.getById(id);
      if(upreimbursementBasicBill != null){
        upreimbursementBasicBill = ObjectCopyUtils.copyProperties(reimbursementBasicBill,upreimbursementBasicBill,true);
      }
      return XfR.ok(reimbursementBasicBillServiceImpl.updateById(upreimbursementBasicBill));
  }

  /**
   * 通过id删除报销基础单据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reimbursementbasicbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reimbursementBasicBillServiceImpl.removeById(id));
  }

  @PostMapping("/reimbursementbasicbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "reimbursement_basic_bill");
     params.put("request", condition);

     return XfR.ok(reimbursementBasicBillServiceImpl.querys(params));
  }

}
