package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.StrokePlan;
import com.xforceplus.ultraman.app.financialsettlement.service.IStrokePlanService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 行程规划前端控制器
 *
 * @author ultraman
 * @date 2022-06-08
 */
@RestController
public class StrokePlanController {

  @Autowired
  private IStrokePlanService strokePlanServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param strokePlan 行程规划
   * @return
   */
  @GetMapping("/strokeplans" )
  public XfR getStrokePlans(XfPage page, StrokePlan strokePlan) {
    return XfR.ok(strokePlanServiceImpl.page(page, Wrappers.query(strokePlan)));
  }

  /**
   * 通过id查询行程规划
   * @param  id
   * @return XfR
   */
  @GetMapping("/strokeplans/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(strokePlanServiceImpl.getById(id));
  }

  /**
   * 新增行程规划
   * @param strokePlan 行程规划
   * @return XfR
   */
  @PostMapping("/strokeplans")
  public XfR save(@RequestBody StrokePlan strokePlan) {
     return XfR.ok(strokePlanServiceImpl.save(strokePlan));
  }

  /**
   * 修改-传入修改后的全部数据行程规划
   * @param strokePlan 行程规划
   * @return XfR
   */
  @PutMapping("/strokeplans/{id}")
  public XfR putUpdate(@RequestBody StrokePlan strokePlan,@PathVariable Long id) {
      strokePlan.setId(id);
      return XfR.ok(strokePlanServiceImpl.updateById(strokePlan));
  }

  /**
   * 修改-传入修改的数据行程规划
   * @param strokePlan 行程规划
   * @return XfR
   */
  @PatchMapping("/strokeplans/{id}")
  public XfR patchUpdate(@RequestBody StrokePlan strokePlan,@PathVariable Long id) {
      StrokePlan upstrokePlan = strokePlanServiceImpl.getById(id);
      if(upstrokePlan != null){
        upstrokePlan = ObjectCopyUtils.copyProperties(strokePlan,upstrokePlan,true);
      }
      return XfR.ok(strokePlanServiceImpl.updateById(upstrokePlan));
  }

  /**
   * 通过id删除行程规划
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/strokeplans/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(strokePlanServiceImpl.removeById(id));
  }

  @PostMapping("/strokeplans/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "stroke_plan");
     params.put("request", condition);

     return XfR.ok(strokePlanServiceImpl.querys(params));
  }

}
