package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeCodeBudgetUsage;
import com.xforceplus.ultraman.app.financialsettlement.service.IChargeCodeBudgetUsageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-29
 */
@RestController
public class ChargeCodeBudgetUsageController {

  @Autowired
  private IChargeCodeBudgetUsageService chargeCodeBudgetUsageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeBudgetUsage ${table.comment}
   * @return
   */
  @GetMapping("/chargecodebudgetusages" )
  public XfR getChargeCodeBudgetUsages(XfPage page, ChargeCodeBudgetUsage chargeCodeBudgetUsage) {
    return XfR.ok(chargeCodeBudgetUsageServiceImpl.page(page, Wrappers.query(chargeCodeBudgetUsage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodebudgetusages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetUsageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCodeBudgetUsage ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodebudgetusages")
  public XfR save(@RequestBody ChargeCodeBudgetUsage chargeCodeBudgetUsage) {
     return XfR.ok(chargeCodeBudgetUsageServiceImpl.save(chargeCodeBudgetUsage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCodeBudgetUsage ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodebudgetusages/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeBudgetUsage chargeCodeBudgetUsage,@PathVariable Long id) {
      chargeCodeBudgetUsage.setId(id);
      return XfR.ok(chargeCodeBudgetUsageServiceImpl.updateById(chargeCodeBudgetUsage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCodeBudgetUsage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodebudgetusages/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeBudgetUsage chargeCodeBudgetUsage,@PathVariable Long id) {
      ChargeCodeBudgetUsage upchargeCodeBudgetUsage = chargeCodeBudgetUsageServiceImpl.getById(id);
      if(upchargeCodeBudgetUsage != null){
        upchargeCodeBudgetUsage = ObjectCopyUtils.copyProperties(chargeCodeBudgetUsage,upchargeCodeBudgetUsage,true);
      }
      return XfR.ok(chargeCodeBudgetUsageServiceImpl.updateById(upchargeCodeBudgetUsage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodebudgetusages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetUsageServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodebudgetusages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_budget_usage");
     params.put("request", condition);

     return XfR.ok(chargeCodeBudgetUsageServiceImpl.querys(params));
  }

}
