package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeMonthData;
import com.xforceplus.ultraman.app.financialsettlement.service.IChargeMonthDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-29
 */
@RestController
public class ChargeMonthDataController {

  @Autowired
  private IChargeMonthDataService chargeMonthDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeMonthData ${table.comment}
   * @return
   */
  @GetMapping("/chargemonthdatas" )
  public XfR getChargeMonthDatas(XfPage page, ChargeMonthData chargeMonthData) {
    return XfR.ok(chargeMonthDataServiceImpl.page(page, Wrappers.query(chargeMonthData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargemonthdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeMonthDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeMonthData ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargemonthdatas")
  public XfR save(@RequestBody ChargeMonthData chargeMonthData) {
     return XfR.ok(chargeMonthDataServiceImpl.save(chargeMonthData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeMonthData ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargemonthdatas/{id}")
  public XfR putUpdate(@RequestBody ChargeMonthData chargeMonthData,@PathVariable Long id) {
      chargeMonthData.setId(id);
      return XfR.ok(chargeMonthDataServiceImpl.updateById(chargeMonthData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeMonthData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargemonthdatas/{id}")
  public XfR patchUpdate(@RequestBody ChargeMonthData chargeMonthData,@PathVariable Long id) {
      ChargeMonthData upchargeMonthData = chargeMonthDataServiceImpl.getById(id);
      if(upchargeMonthData != null){
        upchargeMonthData = ObjectCopyUtils.copyProperties(chargeMonthData,upchargeMonthData,true);
      }
      return XfR.ok(chargeMonthDataServiceImpl.updateById(upchargeMonthData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargemonthdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeMonthDataServiceImpl.removeById(id));
  }

  @PostMapping("/chargemonthdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_month_data");
     params.put("request", condition);

     return XfR.ok(chargeMonthDataServiceImpl.querys(params));
  }

}
