package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialAssetsBackBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialAssetsBackBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 资产的归还申请单明细前端控制器
 *
 * @author ultraman
 * @date 2022-07-29
 */
@RestController
public class FinancialAssetsBackBillDetailController {

  @Autowired
  private IFinancialAssetsBackBillDetailService financialAssetsBackBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialAssetsBackBillDetail 资产的归还申请单明细
   * @return
   */
  @GetMapping("/financialassetsbackbilldetails" )
  public XfR getFinancialAssetsBackBillDetails(XfPage page, FinancialAssetsBackBillDetail financialAssetsBackBillDetail) {
    return XfR.ok(financialAssetsBackBillDetailServiceImpl.page(page, Wrappers.query(financialAssetsBackBillDetail)));
  }

  /**
   * 通过id查询资产的归还申请单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialassetsbackbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialAssetsBackBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增资产的归还申请单明细
   * @param financialAssetsBackBillDetail 资产的归还申请单明细
   * @return XfR
   */
  @PostMapping("/financialassetsbackbilldetails")
  public XfR save(@RequestBody FinancialAssetsBackBillDetail financialAssetsBackBillDetail) {
     return XfR.ok(financialAssetsBackBillDetailServiceImpl.save(financialAssetsBackBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据资产的归还申请单明细
   * @param financialAssetsBackBillDetail 资产的归还申请单明细
   * @return XfR
   */
  @PutMapping("/financialassetsbackbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialAssetsBackBillDetail financialAssetsBackBillDetail,@PathVariable Long id) {
      financialAssetsBackBillDetail.setId(id);
      return XfR.ok(financialAssetsBackBillDetailServiceImpl.updateById(financialAssetsBackBillDetail));
  }

  /**
   * 修改-传入修改的数据资产的归还申请单明细
   * @param financialAssetsBackBillDetail 资产的归还申请单明细
   * @return XfR
   */
  @PatchMapping("/financialassetsbackbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialAssetsBackBillDetail financialAssetsBackBillDetail,@PathVariable Long id) {
      FinancialAssetsBackBillDetail upfinancialAssetsBackBillDetail = financialAssetsBackBillDetailServiceImpl.getById(id);
      if(upfinancialAssetsBackBillDetail != null){
        upfinancialAssetsBackBillDetail = ObjectCopyUtils.copyProperties(financialAssetsBackBillDetail,upfinancialAssetsBackBillDetail,true);
      }
      return XfR.ok(financialAssetsBackBillDetailServiceImpl.updateById(upfinancialAssetsBackBillDetail));
  }

  /**
   * 通过id删除资产的归还申请单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialassetsbackbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialAssetsBackBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialassetsbackbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_assets_back_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialAssetsBackBillDetailServiceImpl.querys(params));
  }

}
