package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialCityReimbursementBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialCityReimbursementBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-29
 */
@RestController
public class FinancialCityReimbursementBillController {

  @Autowired
  private IFinancialCityReimbursementBillService financialCityReimbursementBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialCityReimbursementBill ${table.comment}
   * @return
   */
  @GetMapping("/financialcityreimbursementbills" )
  public XfR getFinancialCityReimbursementBills(XfPage page, FinancialCityReimbursementBill financialCityReimbursementBill) {
    return XfR.ok(financialCityReimbursementBillServiceImpl.page(page, Wrappers.query(financialCityReimbursementBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialcityreimbursementbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialCityReimbursementBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialCityReimbursementBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialcityreimbursementbills")
  public XfR save(@RequestBody FinancialCityReimbursementBill financialCityReimbursementBill) {
     return XfR.ok(financialCityReimbursementBillServiceImpl.save(financialCityReimbursementBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialCityReimbursementBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialcityreimbursementbills/{id}")
  public XfR putUpdate(@RequestBody FinancialCityReimbursementBill financialCityReimbursementBill,@PathVariable Long id) {
      financialCityReimbursementBill.setId(id);
      return XfR.ok(financialCityReimbursementBillServiceImpl.updateById(financialCityReimbursementBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialCityReimbursementBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialcityreimbursementbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialCityReimbursementBill financialCityReimbursementBill,@PathVariable Long id) {
      FinancialCityReimbursementBill upfinancialCityReimbursementBill = financialCityReimbursementBillServiceImpl.getById(id);
      if(upfinancialCityReimbursementBill != null){
        upfinancialCityReimbursementBill = ObjectCopyUtils.copyProperties(financialCityReimbursementBill,upfinancialCityReimbursementBill,true);
      }
      return XfR.ok(financialCityReimbursementBillServiceImpl.updateById(upfinancialCityReimbursementBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialcityreimbursementbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialCityReimbursementBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialcityreimbursementbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_city_reimbursement_bill");
     params.put("request", condition);

     return XfR.ok(financialCityReimbursementBillServiceImpl.querys(params));
  }

}
