package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialCityBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialCityBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-19
 */
@RestController
public class FinancialCityBillDetailController {

  @Autowired
  private IFinancialCityBillDetailService financialCityBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialCityBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialcitybilldetails" )
  public XfR getFinancialCityBillDetails(XfPage page, FinancialCityBillDetail financialCityBillDetail) {
    return XfR.ok(financialCityBillDetailServiceImpl.page(page, Wrappers.query(financialCityBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialcitybilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialCityBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialCityBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialcitybilldetails")
  public XfR save(@RequestBody FinancialCityBillDetail financialCityBillDetail) {
     return XfR.ok(financialCityBillDetailServiceImpl.save(financialCityBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialCityBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialcitybilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialCityBillDetail financialCityBillDetail,@PathVariable Long id) {
      financialCityBillDetail.setId(id);
      return XfR.ok(financialCityBillDetailServiceImpl.updateById(financialCityBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialCityBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialcitybilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialCityBillDetail financialCityBillDetail,@PathVariable Long id) {
      FinancialCityBillDetail upfinancialCityBillDetail = financialCityBillDetailServiceImpl.getById(id);
      if(upfinancialCityBillDetail != null){
        upfinancialCityBillDetail = ObjectCopyUtils.copyProperties(financialCityBillDetail,upfinancialCityBillDetail,true);
      }
      return XfR.ok(financialCityBillDetailServiceImpl.updateById(upfinancialCityBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialcitybilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialCityBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialcitybilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_city_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialCityBillDetailServiceImpl.querys(params));
  }

}
