package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.NoNeedList;
import com.xforceplus.ultraman.app.financialsettlement.service.INoNeedListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-19
 */
@RestController
public class NoNeedListController {

  @Autowired
  private INoNeedListService noNeedListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param noNeedList ${table.comment}
   * @return
   */
  @GetMapping("/noneedlists" )
  public XfR getNoNeedLists(XfPage page, NoNeedList noNeedList) {
    return XfR.ok(noNeedListServiceImpl.page(page, Wrappers.query(noNeedList)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/noneedlists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(noNeedListServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param noNeedList ${table.comment}
   * @return XfR
   */
  @PostMapping("/noneedlists")
  public XfR save(@RequestBody NoNeedList noNeedList) {
     return XfR.ok(noNeedListServiceImpl.save(noNeedList));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param noNeedList ${table.comment}
   * @return XfR
   */
  @PutMapping("/noneedlists/{id}")
  public XfR putUpdate(@RequestBody NoNeedList noNeedList,@PathVariable Long id) {
      noNeedList.setId(id);
      return XfR.ok(noNeedListServiceImpl.updateById(noNeedList));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param noNeedList ${table.comment}
   * @return XfR
   */
  @PatchMapping("/noneedlists/{id}")
  public XfR patchUpdate(@RequestBody NoNeedList noNeedList,@PathVariable Long id) {
      NoNeedList upnoNeedList = noNeedListServiceImpl.getById(id);
      if(upnoNeedList != null){
        upnoNeedList = ObjectCopyUtils.copyProperties(noNeedList,upnoNeedList,true);
      }
      return XfR.ok(noNeedListServiceImpl.updateById(upnoNeedList));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/noneedlists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(noNeedListServiceImpl.removeById(id));
  }

  @PostMapping("/noneedlists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "no_need_list");
     params.put("request", condition);

     return XfR.ok(noNeedListServiceImpl.querys(params));
  }

}
