package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.SettlementDetailAndInvoiceRelation;
import com.xforceplus.ultraman.app.financialsettlement.service.ISettlementDetailAndInvoiceRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 结算表明细与发票关系前端控制器
 *
 * @author ultraman
 * @date 2022-08-19
 */
@RestController
public class SettlementDetailAndInvoiceRelationController {

  @Autowired
  private ISettlementDetailAndInvoiceRelationService settlementDetailAndInvoiceRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementDetailAndInvoiceRelation 结算表明细与发票关系
   * @return
   */
  @GetMapping("/settlementdetailandinvoicerelations" )
  public XfR getSettlementDetailAndInvoiceRelations(XfPage page, SettlementDetailAndInvoiceRelation settlementDetailAndInvoiceRelation) {
    return XfR.ok(settlementDetailAndInvoiceRelationServiceImpl.page(page, Wrappers.query(settlementDetailAndInvoiceRelation)));
  }

  /**
   * 通过id查询结算表明细与发票关系
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementdetailandinvoicerelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementDetailAndInvoiceRelationServiceImpl.getById(id));
  }

  /**
   * 新增结算表明细与发票关系
   * @param settlementDetailAndInvoiceRelation 结算表明细与发票关系
   * @return XfR
   */
  @PostMapping("/settlementdetailandinvoicerelations")
  public XfR save(@RequestBody SettlementDetailAndInvoiceRelation settlementDetailAndInvoiceRelation) {
     return XfR.ok(settlementDetailAndInvoiceRelationServiceImpl.save(settlementDetailAndInvoiceRelation));
  }

  /**
   * 修改-传入修改后的全部数据结算表明细与发票关系
   * @param settlementDetailAndInvoiceRelation 结算表明细与发票关系
   * @return XfR
   */
  @PutMapping("/settlementdetailandinvoicerelations/{id}")
  public XfR putUpdate(@RequestBody SettlementDetailAndInvoiceRelation settlementDetailAndInvoiceRelation,@PathVariable Long id) {
      settlementDetailAndInvoiceRelation.setId(id);
      return XfR.ok(settlementDetailAndInvoiceRelationServiceImpl.updateById(settlementDetailAndInvoiceRelation));
  }

  /**
   * 修改-传入修改的数据结算表明细与发票关系
   * @param settlementDetailAndInvoiceRelation 结算表明细与发票关系
   * @return XfR
   */
  @PatchMapping("/settlementdetailandinvoicerelations/{id}")
  public XfR patchUpdate(@RequestBody SettlementDetailAndInvoiceRelation settlementDetailAndInvoiceRelation,@PathVariable Long id) {
      SettlementDetailAndInvoiceRelation upsettlementDetailAndInvoiceRelation = settlementDetailAndInvoiceRelationServiceImpl.getById(id);
      if(upsettlementDetailAndInvoiceRelation != null){
        upsettlementDetailAndInvoiceRelation = ObjectCopyUtils.copyProperties(settlementDetailAndInvoiceRelation,upsettlementDetailAndInvoiceRelation,true);
      }
      return XfR.ok(settlementDetailAndInvoiceRelationServiceImpl.updateById(upsettlementDetailAndInvoiceRelation));
  }

  /**
   * 通过id删除结算表明细与发票关系
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementdetailandinvoicerelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementDetailAndInvoiceRelationServiceImpl.removeById(id));
  }

  @PostMapping("/settlementdetailandinvoicerelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_detail_and_invoice_relation");
     params.put("request", condition);

     return XfR.ok(settlementDetailAndInvoiceRelationServiceImpl.querys(params));
  }

}
