package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialHesWriteoffBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialHesWriteoffBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-22
 */
@RestController
public class FinancialHesWriteoffBillController {

  @Autowired
  private IFinancialHesWriteoffBillService financialHesWriteoffBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialHesWriteoffBill ${table.comment}
   * @return
   */
  @GetMapping("/financialheswriteoffbills" )
  public XfR getFinancialHesWriteoffBills(XfPage page, FinancialHesWriteoffBill financialHesWriteoffBill) {
    return XfR.ok(financialHesWriteoffBillServiceImpl.page(page, Wrappers.query(financialHesWriteoffBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialheswriteoffbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialHesWriteoffBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialHesWriteoffBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialheswriteoffbills")
  public XfR save(@RequestBody FinancialHesWriteoffBill financialHesWriteoffBill) {
     return XfR.ok(financialHesWriteoffBillServiceImpl.save(financialHesWriteoffBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialHesWriteoffBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialheswriteoffbills/{id}")
  public XfR putUpdate(@RequestBody FinancialHesWriteoffBill financialHesWriteoffBill,@PathVariable Long id) {
      financialHesWriteoffBill.setId(id);
      return XfR.ok(financialHesWriteoffBillServiceImpl.updateById(financialHesWriteoffBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialHesWriteoffBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialheswriteoffbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialHesWriteoffBill financialHesWriteoffBill,@PathVariable Long id) {
      FinancialHesWriteoffBill upfinancialHesWriteoffBill = financialHesWriteoffBillServiceImpl.getById(id);
      if(upfinancialHesWriteoffBill != null){
        upfinancialHesWriteoffBill = ObjectCopyUtils.copyProperties(financialHesWriteoffBill,upfinancialHesWriteoffBill,true);
      }
      return XfR.ok(financialHesWriteoffBillServiceImpl.updateById(upfinancialHesWriteoffBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialheswriteoffbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialHesWriteoffBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialheswriteoffbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_hes_writeoff_bill");
     params.put("request", condition);

     return XfR.ok(financialHesWriteoffBillServiceImpl.querys(params));
  }

}
