package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialResponsibleChangeBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialResponsibleChangeBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-22
 */
@RestController
public class FinancialResponsibleChangeBillController {

  @Autowired
  private IFinancialResponsibleChangeBillService financialResponsibleChangeBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialResponsibleChangeBill ${table.comment}
   * @return
   */
  @GetMapping("/financialresponsiblechangebills" )
  public XfR getFinancialResponsibleChangeBills(XfPage page, FinancialResponsibleChangeBill financialResponsibleChangeBill) {
    return XfR.ok(financialResponsibleChangeBillServiceImpl.page(page, Wrappers.query(financialResponsibleChangeBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialresponsiblechangebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialResponsibleChangeBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialResponsibleChangeBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialresponsiblechangebills")
  public XfR save(@RequestBody FinancialResponsibleChangeBill financialResponsibleChangeBill) {
     return XfR.ok(financialResponsibleChangeBillServiceImpl.save(financialResponsibleChangeBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialResponsibleChangeBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialresponsiblechangebills/{id}")
  public XfR putUpdate(@RequestBody FinancialResponsibleChangeBill financialResponsibleChangeBill,@PathVariable Long id) {
      financialResponsibleChangeBill.setId(id);
      return XfR.ok(financialResponsibleChangeBillServiceImpl.updateById(financialResponsibleChangeBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialResponsibleChangeBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialresponsiblechangebills/{id}")
  public XfR patchUpdate(@RequestBody FinancialResponsibleChangeBill financialResponsibleChangeBill,@PathVariable Long id) {
      FinancialResponsibleChangeBill upfinancialResponsibleChangeBill = financialResponsibleChangeBillServiceImpl.getById(id);
      if(upfinancialResponsibleChangeBill != null){
        upfinancialResponsibleChangeBill = ObjectCopyUtils.copyProperties(financialResponsibleChangeBill,upfinancialResponsibleChangeBill,true);
      }
      return XfR.ok(financialResponsibleChangeBillServiceImpl.updateById(upfinancialResponsibleChangeBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialresponsiblechangebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialResponsibleChangeBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialresponsiblechangebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_responsible_change_bill");
     params.put("request", condition);

     return XfR.ok(financialResponsibleChangeBillServiceImpl.querys(params));
  }

}
