package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialPersonLoanBackBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialPersonLoanBackBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 个人借款归还单前端控制器
 *
 * @author ultraman
 * @date 2022-09-02
 */
@RestController
public class FinancialPersonLoanBackBillController {

  @Autowired
  private IFinancialPersonLoanBackBillService financialPersonLoanBackBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPersonLoanBackBill 个人借款归还单
   * @return
   */
  @GetMapping("/financialpersonloanbackbills" )
  public XfR getFinancialPersonLoanBackBills(XfPage page, FinancialPersonLoanBackBill financialPersonLoanBackBill) {
    return XfR.ok(financialPersonLoanBackBillServiceImpl.page(page, Wrappers.query(financialPersonLoanBackBill)));
  }

  /**
   * 通过id查询个人借款归还单
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpersonloanbackbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPersonLoanBackBillServiceImpl.getById(id));
  }

  /**
   * 新增个人借款归还单
   * @param financialPersonLoanBackBill 个人借款归还单
   * @return XfR
   */
  @PostMapping("/financialpersonloanbackbills")
  public XfR save(@RequestBody FinancialPersonLoanBackBill financialPersonLoanBackBill) {
     return XfR.ok(financialPersonLoanBackBillServiceImpl.save(financialPersonLoanBackBill));
  }

  /**
   * 修改-传入修改后的全部数据个人借款归还单
   * @param financialPersonLoanBackBill 个人借款归还单
   * @return XfR
   */
  @PutMapping("/financialpersonloanbackbills/{id}")
  public XfR putUpdate(@RequestBody FinancialPersonLoanBackBill financialPersonLoanBackBill,@PathVariable Long id) {
      financialPersonLoanBackBill.setId(id);
      return XfR.ok(financialPersonLoanBackBillServiceImpl.updateById(financialPersonLoanBackBill));
  }

  /**
   * 修改-传入修改的数据个人借款归还单
   * @param financialPersonLoanBackBill 个人借款归还单
   * @return XfR
   */
  @PatchMapping("/financialpersonloanbackbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialPersonLoanBackBill financialPersonLoanBackBill,@PathVariable Long id) {
      FinancialPersonLoanBackBill upfinancialPersonLoanBackBill = financialPersonLoanBackBillServiceImpl.getById(id);
      if(upfinancialPersonLoanBackBill != null){
        upfinancialPersonLoanBackBill = ObjectCopyUtils.copyProperties(financialPersonLoanBackBill,upfinancialPersonLoanBackBill,true);
      }
      return XfR.ok(financialPersonLoanBackBillServiceImpl.updateById(upfinancialPersonLoanBackBill));
  }

  /**
   * 通过id删除个人借款归还单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpersonloanbackbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPersonLoanBackBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialpersonloanbackbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_person_loan_back_bill");
     params.put("request", condition);

     return XfR.ok(financialPersonLoanBackBillServiceImpl.querys(params));
  }

}
