package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.PaymentConfig;
import com.xforceplus.ultraman.app.financialsettlement.service.IPaymentConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-02
 */
@RestController
public class PaymentConfigController {

  @Autowired
  private IPaymentConfigService paymentConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param paymentConfig ${table.comment}
   * @return
   */
  @GetMapping("/paymentconfigs" )
  public XfR getPaymentConfigs(XfPage page, PaymentConfig paymentConfig) {
    return XfR.ok(paymentConfigServiceImpl.page(page, Wrappers.query(paymentConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/paymentconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(paymentConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param paymentConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/paymentconfigs")
  public XfR save(@RequestBody PaymentConfig paymentConfig) {
     return XfR.ok(paymentConfigServiceImpl.save(paymentConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param paymentConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/paymentconfigs/{id}")
  public XfR putUpdate(@RequestBody PaymentConfig paymentConfig,@PathVariable Long id) {
      paymentConfig.setId(id);
      return XfR.ok(paymentConfigServiceImpl.updateById(paymentConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param paymentConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/paymentconfigs/{id}")
  public XfR patchUpdate(@RequestBody PaymentConfig paymentConfig,@PathVariable Long id) {
      PaymentConfig uppaymentConfig = paymentConfigServiceImpl.getById(id);
      if(uppaymentConfig != null){
        uppaymentConfig = ObjectCopyUtils.copyProperties(paymentConfig,uppaymentConfig,true);
      }
      return XfR.ok(paymentConfigServiceImpl.updateById(uppaymentConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paymentconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(paymentConfigServiceImpl.removeById(id));
  }

  @PostMapping("/paymentconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "payment_config");
     params.put("request", condition);

     return XfR.ok(paymentConfigServiceImpl.querys(params));
  }

}
